ORCA/M Asm65816 2.1.0

0001 4123                       TITLE 'Format Volume'
0002 4123
0003 4123              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 4123              ;	by EdAsmCvtIIGS version 1.2d8 on 5/16/91 at 9:22:43 PM
0005 4123
0006 4123              **************************************************
0007 4123              *                                               
0008 4123              *  Format Volume    Format an diskette based on
0009 4123              *		the media type 800K for DD
0010 4123              *		or 1440K for HD media
0011 4123              *
0012 4123              *	Don't allow formatting 800K on 1440 media
0013 4123              *                                               
0014 4123              **************************************************
0015 4123              FORMATVOL EQU   *
0016 4123 5C 8F 0F E1           JMP   FormatHook
0017 4127              Format~VOL:  
0018 4127 A9 03                 LDA   #ejct_reset              ; reset ejected bit
0019 4129 20 85 49              JSR   writebit                 ;to supress DSWerr from SensnChk
0020 412C 38                    SEC                            ;need the WP error here
0021 412D 20 05 4A              JSR   SensnChk                 ;enable,Sense, and chk volsts
0022 4130 90 04                 BCC   @20                      ;media is online
0023 4132 8D 4B 0F              STA   statbyte                 ;offline or WritProt 
0024 4135 60                    RTS   
0025 4136
0026 4136              *
0027 4136              * Prep to start the track loop
0028 4136 20 47 49     @20      JSR   MotorOn                  ;enable motor (SEEK doesn't doit now)
0029 4139 20 82 48              JSR   recal                    ;Start out on the right foot
0030 413C B0 4B                 BCS   fmterr
0031 413E              *
0032 413E 9C 29 0F              STZ   cyl
0033 4141 9C 2B 0F              STZ   side                     ;Start on side 0 
0034 4144              *
0035 4144              @TRKLP   EQU   *
0036 4144 A9 0A                 LDA   #fmtretry
0037 4146 85 5C                 STA   fmtTrkretry              ;Set retry count
0038 4148              *
0039 4148              * Write out an entire track
0040 4148 20 93 41     @RTRY    JSR   writetrk
0041 414B B0 3C                 BCS   fmterr                   ;If there was any problem, escape
0042 414D              *
0043 414D              * Now verify that we wrote it correctly
0044 414D 20 62 43              JSR   verify
0045 4150 90 0D                 BCC   @30                      ;Skip retries if verify okay 
0046 4152              *
0047 4152 C6 5C                 DEC   fmtTrkretry
0048 4154 F0 33                 BEQ   fmterr                   ;I/O error if verify fails rptdly
0049 4156 AD 4B 0F              LDA   statbyte                 ;rdadrs return offline?
0050 4159 C9 2F                 CMP   #offline
0051 415B D0 EB                 BNE   @rtry                    ;no. so try again
0052 415D 80 2F                 BRA   fmterror                 ;return offline!!!
0053 415F              *
0054 415F              * Flip the side if it's a double sided disk
0055 415F              @30      EQU   *
0056 415F 20 03 56              JSR   open_wndw                ; open an interrupt window
0057 4162 2C 50 0F              BIT   formsides                ;Set N flag to double sided
0058 4165 10 0A                 BPL   @40                      ;If 1 sided, leave side alone 
0059 4167 A9 80                 LDA   #$80                     ;2 sided: Flip side 
0060 4169 4D 2B 0F              EOR   side
0061 416C 8D 2B 0F              STA   side
0062 416F D0 D3                 BNE   @trklp                   ;If side 1 now, back to write it
0063 4171              *
0064 4171              * Advance to the next cylinder 
0065 4171 EE 29 0F     @40      INC   cyl
0066 4174 AD 29 0F              LDA   cyl
0067 4177 C9 50                 CMP   #totcyls
0068 4179 90 C9                 BLT   @trklp                   ;If more cyls, do 'em
0069 417B              *
0070 417B AE 28 0F              LDX   drive
0071 417E 20 EE 44              JSR   ResetFmt                 ;return Format Option to default
0072 4181 18                    CLC                            ;no prior error
0073 4182 20 68 47              JSR   MountVol                 ;determine volume type
0074 4185 B0 07                 BCS   fmterror                 ;can't read adrs after format?????
0075 4187 18                    CLC   
0076 4188 60                    RTS                            ;Return- everything AOK
0077 4189              *
0078 4189 A9 27        FMTERR   LDA   #ioerror
0079 418B 8D 4B 0F              STA   statbyte
0080 418E 20 AE 48     FMTERROR JSR   eject
0081 4191 38                    SEC   
0082 4192 60           RTS33    RTS                            ;Return w/ carry set
0083 4193                       TITLE 'Write out a Track'
0084 4193              **************************************************
0085 4193              *                                                *
0086 4193              *  writetrk       Write an entire track to disk  * 
0087 4193              *                                                *
0088 4193              *   Input:    cyl, side                          *
0089 4193              *   Uses:     seek, initwtrk                     *
0090 4193              *   Destroys: A,X,Y, temp                        *
0091 4193              *                                                *
0092 4193              **************************************************
0093 4193              WRITETRK EQU   *
0094 4193 5C 97 0F E1  @doGCR   JMP   WriteTrkHook
0095 4197              *
0096 4197 20 26 48     WriteTrk~GCR JSR   seek
0097 419A 20 8E 42              JSR   makesect                 ;Generate a sector image in RAM 
0098 419D 20 E0 42              JSR   initwtrk
0099 41A0 20 25 49              JSR   WaitRdyTO
0100 41A3 B0 ED                 BCS   rts33                    ;return an error
0101 41A5              *
0102 41A5              * To meet the Sony formatting spec, one must wait extra time
0103 41A5              *  on track 0 and others that are the first of a speed class.
0104 41A5              *
0105 41A5 AD 2B 0F              LDA   side
0106 41A8 D0 16                 BNE   wtnowait
0107 41AA              *
0108 41AA AD 29 0F              LDA   cyl
0109 41AD 29 0F                 AND   #$0F
0110 41AF D0 0F                 BNE   wtnowait                 ;If not 1st of speed class
0111 41B1              *
0112 41B1 AD 29 0F              LDA   cyl                      ;Get back again
0113 41B4 4A                    LSR   a
0114 41B5 4A                    LSR   a
0115 41B6 4A                    LSR   a
0116 41B7 4A                    LSR   a
0117 41B8 AA                    TAX   
0118 41B9 BF 74 3C FF           LDA   >fmtwtab,x
0119 41BD 20 5D 4A              JSR   wait2ms
0120 41C0              *
0121 41C0              WTNOWAIT EQU   *
0122 41C0 20 C6 4C              JSR   rdmode                   ;Set the head correctly
0123 41C3 64 5A                 STZ   temp
0124 41C5 A9 FF                 LDA   #$FF
0125 41C7 2C ED C0              BIT   l6set                    ;Prep to write
0126 41CA 8D EF C0              STA   l7set
0127 41CD A9 00                 LDA   #>itssize
0128 41CF A2 C8                 LDX   #<itssize
0129 41D1 85 5B                 STA   temp2
0130 41D3              *
0131 41D3              * Write out 20 microsec sync marks (pre-track)
0132 41D3              *
0133 41D3 A0 04        WSYNB    LDY   #4                       ;(2)
0134 41D5 B9 5C 0F     WSYND    LDA   synctab,y                ;(4)
0135 41D8 2C EC C0     WSYNA    BIT   l6clr
0136 41DB 10 FB                 BPL   wsyna
0137 41DD 8D ED C0              STA   l6set                    ;(4)
0138 41E0 88                    DEY                            ;(2)
0139 41E1 10 F2                 BPL   wsynd                    ;(3,2)
0140 41E3 CA                    DEX                            ;(2) 
0141 41E4 D0 ED                 BNE   wsynb                    ;(3,2)
0142 41E6 C6 5B                 DEC   temp2                    ;(5)
0143 41E8 10 E9                 BPL   wsynb                    ;(3,2)
0144 41EA              *
0145 41EA              * Copy out the header and marks to the disk
0146 41EA              *
0147 41EA              FMTSLOOP EQU   *
0148 41EA C2 10                 REP   #$10                     ;(2) 16 bit indexes
0149 41EC E2 20                 SEP   #$20                     ;(2)
0150 41EE                       LONGA OFF                      	; 8 bit accumulator
0151 41EE                       LONGI ON                       	; 16 bit indexes
0152 41EE A0 00 00              LDY   #0000                    ;(3) Get count from buffer
0153 41F1 AE 00 0C              LDX   sectbuf                  ;(5) get header field length
0154 41F4 B9 02 0C     @20      LDA   sectbuf+2,y              ;(6..9) Get a byte in the sector
0155 41F7 2C EC C0     @30      BIT   l6clr                    ;(6-9,11)
0156 41FA 10 FB                 BPL   @30                      ;(3)
0157 41FC 8D ED C0              STA   l6set                    ;(3) Start it writing out
0158 41FF C8                    INY                            ;(2) Next byte
0159 4200 CA                    DEX                            ;(2) 
0160 4201 D0 F1                 BNE   @20                      ;(3) Waste more time if not
0161 4203                       LONGA ON
0162 4203 C2 20                 REP   #$20
0163 4205 B9 02 0C              LDA   sectbuf+2,y              ;get 16 bit repeat count
0164 4208 AA                    TAX                            ;    repeat count is 1 based
0165 4209                       LONGA OFF
0166 4209 E2 20                 SEP   #$20
0167 420B              *
0168 420B B9 04 0C              LDA   sectbuf+4,y              ;get repeat byte
0169 420E 2C EC C0     @40      BIT   l6clr
0170 4211 10 FB                 BPL   @40
0171 4213 8D ED C0              STA   l6set
0172 4216 CA                    DEX   
0173 4217 D0 F5                 BNE   @40
0174 4219              *
0175 4219                       LONGA ON
0176 4219 C2 20                 REP   #$20
0177 421B B9 05 0C              LDA   sectbuf+5,y              ;get 2nd field length
0178 421E AA                    TAX   
0179 421F                       LONGA OFF
0180 421F E2 20                 SEP   #$20
0181 4221 B9 07 0C     @50      LDA   sectbuf+7,y
0182 4224 2C EC C0     @60      BIT   l6clr
0183 4227 10 FB                 BPL   @60
0184 4229 8D ED C0              STA   l6set
0185 422C C8                    INY                            ;(2)
0186 422D CA                    DEX                            ;(2)
0187 422E D0 F1                 BNE   @50                      ;(2)
0188 4230              *
0189 4230 E2 10                 SEP   #$10                     ;(2) 8 bit indexes
0190 4232                       LONGI OFF                      	; 8 bit accumulator
0191 4232              *
0192 4232              * More sectors this track?
0193 4232              *
0194 4232 E6 5A                 INC   temp                     ;(5)
0195 4234 A4 5A                 LDY   temp                     ;(3) Sectors out so far
0196 4236 CC 2C 0F              CPY   curnsect                 ;(9)
0197 4239 B0 37                 BGE   donetrk                  ;(2) If done, skip out
0198 423B              *
0199 423B              * Now, in order to keep the IWM in write mode, must write
0200 423B              *  a byte to keep from underflow.  Remember, the inner write
0201 423B              *  loop above is small (<32 cyc), so the IWM would not underflow
0202 423B              *  until well into the SECOND byte time.
0203 423B              *
0204 423B A9 FF                 LDA   #$FF                     ;(2)
0205 423D 2C EC C0     @70      BIT   l6clr                    ;(9) wait for buffer empty
0206 4240 10 FB                 BPL   @70                      ;(3)
0207 4242 8D ED C0              STA   l6set                    ;(9) Pop out an $FF
0208 4245              *
0209 4245              * Need another sector... update the sector number
0210 4245              *
0211 4245 BE 00 0F              LDX   xlvtab,y                 ;(9) Translate to logical sect#
0212 4248 BF 00 3D FF           LDA   >nibtab,x                ;(5) Nibbilize it
0213 424C 8D 48 0C              STA   volasect                 ;(9) Place in address field
0214 424F 8D 58 0C              STA   voldsect                 ;(9) and in the data field
0215 4252              ;
0216 4252 A0 FF                 LDY   #$FF                     ;(2) keep on writing....
0217 4254 2C EC C0     @80      BIT   l6clr                    ;(6,9) wait for buffer empty
0218 4257 10 FB                 BPL   @80                      ;(3)
0219 4259 8C ED C0              STY   l6set                    ;(9)
0220 425C              *
0221 425C              * Now update the checksum
0222 425C              *
0223 425C 8A                    TXA                            ;(2) Move the current log sect#
0224 425D 45 4F                 EOR   csum                     ;(3)
0225 425F AA                    TAX                            ;(2) min of 40 fast cycles per nyble
0226 4260 BF 00 3D FF           LDA   >nibtab,x                ;Nibbilize the new sum
0227 4264 8D 4B 0C              STA   volcsum                  ;Into the sector image
0228 4267              *
0229 4267 2C EC C0     @90      BIT   l6clr
0230 426A 10 FB                 BPL   @90
0231 426C 8C ED C0              STY   l6set                    ;out with another sync byte 
0232 426F              ;
0233 426F 82 78 FF              BRL   fmtSloop                 ;Back for more sectors 
0234 4272              *
0235 4272              DONETRK  EQU   *
0236 4272 2C EC C0              BIT   l6clr                    ; wait for underrun
0237 4275 08                    PHP                            ;retain /underrun in v bit
0238 4276 2C EC C0     @100     BIT   l6clr                    ;wait for last byte to underrun
0239 4279 70 FB                 BVS   @100                     ;
0240 427B AD EE C0              LDA   l7clr                    ;Back into read mode
0241 427E AD EC C0              LDA   l6clr
0242 4281 28                    PLP   
0243 4282 38                    SEC   
0244 4283 A9 34                 LDA   #$34                     ;write underrun error for debug
0245 4285 50 03                 BVC   wtrkerr                  ;return an error
0246 4287 A9 00                 LDA   #00
0247 4289 18                    CLC   
0248 428A 8D 43 0F     WTRKERR  STA   error1                   ;save where debug is easy
0249 428D 60                    RTS   
0250 428E              **************************************************
0251 428E              *                                                *
0252 428E              *  makesect      Generate a sector image in RAM  *
0253 428E              *                                                *
0254 428E              * As follows: Length word of header field        *
0255 428E              *             header field bytes                 *
0256 428E              *             count word of repeat field         *
0257 428E              *             repeat byte   (exactly one byte!)  * 
0258 428E              *             length word of trailer field       *
0259 428E              *             trailer field bytes                *
0260 428E              *                                                *
0261 428E              *   Destroys: A, X, Y                            *
0262 428E              *                                                *
0263 428E              **************************************************
0264 428E              MAKESECT EQU   *
0265 428E              *
0266 428E              * Generate intersector gap
0267 428E A9 57                 LDA   #65+22
0268 4290 8D 00 0C              STA   sectbuf                  ;init header field length
0269 4293 9C 01 0C              STZ   sectbuf+1
0270 4296              *
0271 4296 A2 00                 LDX   #00
0272 4298 A0 04        @10      LDY   #4
0273 429A B9 5C 0F     @20      LDA   synctab,y
0274 429D 9D 02 0C              STA   sectbuf+2,x
0275 42A0 E8                    INX   
0276 42A1 E0 41                 CPX   #65
0277 42A3 B0 05                 BCS   @30
0278 42A5 88                    DEY   
0279 42A6 10 F2                 BPL   @20
0280 42A8 80 EE                 BRA   @10
0281 42AA              *
0282 42AA              * the data to sectbuf is reverse order from afdmtab
0283 42AA              * Copy the address field 'skeleton' and data marks
0284 42AA A2 15        @30      LDX   #22-1
0285 42AC A0 00                 LDY   #00
0286 42AE BD 57 0F     @40      LDA   afdmtab,x                ;src from hi adrs
0287 42B1 99 43 0C              STA   sectbuf+2+65,y           ;dest to low adrs
0288 42B4 C8                    INY   
0289 42B5 CA                    DEX   
0290 42B6 10 F6                 BPL   @40
0291 42B8              *
0292 42B8              * repeat field is 703 $96 nybles
0293 42B8 A9 BF                 LDA   #<703
0294 42BA 8D 59 0C              STA   sectbuf+2+65+22
0295 42BD A9 02                 LDA   #>703
0296 42BF 8D 5A 0C              STA   sectbuf+3+65+22
0297 42C2 A9 96                 LDA   #$96
0298 42C4 8D 5B 0C              STA   sectbuf+4+65+22          ;repeat byte
0299 42C7              *
0300 42C7              * Trailer field is just the bit slip marks
0301 42C7 A9 02                 LDA   #<02                     ;old formatter didn't write the
0302 42C9 8D 5C 0C              STA   sectbuf+5+65+22
0303 42CC A9 00                 LDA   #>03                     ;last byt of the 793 byte buffer cuz
0304 42CE 8D 5D 0C              STA   sectbuf+6+65+22
0305 42D1 A2 02                 LDX   #3-1                     ;of the 3 $FF written btween sects
0306 42D3 A0 00                 LDY   #00                      ;
0307 42D5 BD 61 0F     @50      LDA   bsmarks,x
0308 42D8 99 5E 0C              STA   sectbuf+7+65+22,y
0309 42DB C8                    INY   
0310 42DC CA                    DEX   
0311 42DD 10 F6                 BPL   @50
0312 42DF 60                    RTS   
0313 42E0                       TITLE 'Write Track Support'
0314 42E0              **************************************************
0315 42E0              *                                                *
0316 42E0              *  initwtrk      Set interleave table, and init  *
0317 42E0              *                 the RAM sect image for sect 0  *
0318 42E0              *                                                *
0319 42E0              *                                                *
0320 42E0              **************************************************
0321 42E0              INITWTRK EQU   *
0322 42E0              *
0323 42E0              * Generate interleave table
0324 42E0              *
0325 42E0 A9 FF                 LDA   #$FF
0326 42E2 A2 0B                 LDX   #11
0327 42E4              CLEARXTAB EQU   *
0328 42E4 9D 00 0F              STA   xlvtab,x
0329 42E7 CA                    DEX   
0330 42E8 10 FA                 BPL   clearxtab
0331 42EA              *
0332 42EA E8                    INX                            ;X=0
0333 42EB A0 00                 LDY   #0
0334 42ED 98           ALLOCSPOT TYA   
0335 42EE 9D 00 0F              STA   xlvtab,x
0336 42F1 C8                    INY                            ;Physical Sector number
0337 42F2 CC 2C 0F              CPY   curnsect                 ;If all sectors placed, we're done
0338 42F5 B0 18                 BGE   xlvdone
0339 42F7 8A                    TXA                            ;Move index to A to add
0340 42F8 18                    CLC   
0341 42F9 6D 4F 0F              ADC   Interleave
0342 42FC AA                    TAX   
0343 42FD              CHECKBOUND EQU   *
0344 42FD EC 2C 0F              CPX   curnsect
0345 4300 90 05                 BLT   checkspot
0346 4302 8A                    TXA                            ;We wrapped (C=1)
0347 4303 ED 2C 0F              SBC   curnsect
0348 4306 AA                    TAX   
0349 4307              CHECKSPOT EQU   *
0350 4307 3C 00 0F              BIT   xlvtab,x
0351 430A 30 E1                 BMI   allocspot
0352 430C E8                    INX   
0353 430D 80 EE                 BRA   checkbound
0354 430F              *
0355 430F              * Put track into sector image
0356 430F              *
0357 430F              XLVDONE  EQU   *
0358 430F AD 29 0F              LDA   cyl
0359 4312 29 3F                 AND   #$3F                     ;Only lower six bits
0360 4314 85 4F                 STA   csum                     ;Start checksum calc
0361 4316 AA                    TAX   
0362 4317 BF 00 3D FF           LDA   >nibtab,x                ;Nibbilize the track
0363 431B 8D 47 0C              STA   voltrk                   ;Save it
0364 431E              *
0365 431E              * Put side byte into sector image
0366 431E              *
0367 431E AD 29 0F              LDA   cyl                      ;track[6] goes into side 
0368 4321 0A                    ASL   a
0369 4322 0A                    ASL   a
0370 4323 A9 00                 LDA   #0
0371 4325 2A                    ROL   a                        ;A[0] has track[6] 
0372 4326 2C 2B 0F              BIT   side
0373 4329 10 02                 BPL   iwtb
0374 432B 49 20                 EOR   #$20
0375 432D AA           IWTB     TAX   
0376 432E 45 4F                 EOR   csum                     ;Maintain the checksum
0377 4330 85 4F                 STA   csum
0378 4332 BF 00 3D FF           LDA   >nibtab,x
0379 4336 8D 49 0C              STA   volside
0380 4339              *
0381 4339              * Now set the fmt byte
0382 4339              *
0383 4339 AD 4F 0F              LDA   Interleave               ;Whatever it may be
0384 433C 2C 50 0F              BIT   formsides                ;Single or double desired?
0385 433F 10 02                 BPL   iwtc                     ;If one sided, skip down
0386 4341 09 20                 ORA   #$20                     ;Two sides - flip fmt[5]
0387 4343 AA           IWTC     TAX   
0388 4344 45 4F                 EOR   csum
0389 4346 85 4F                 STA   csum                     ;Add into checksum
0390 4348 48                    PHA                            ;Save for a jiffy
0391 4349 BF 00 3D FF           LDA   >nibtab,x                ;Nibbilize the fmt byte
0392 434D 8D 4A 0C              STA   volfmt
0393 4350              *
0394 4350              * Store sector0 and checksum
0395 4350 68                    PLA                            ;Get back csum
0396 4351 AA                    TAX   
0397 4352 BF 00 3D FF           LDA   >nibtab,x                ;Nibbilize
0398 4356 8D 4B 0C              STA   volcsum
0399 4359 A9 96                 LDA   #$96
0400 435B 8D 48 0C              STA   volasect                 ;Save sector 0 in add field
0401 435E 8D 58 0C              STA   voldsect                 ; and in data field
0402 4361 60                    RTS   
0403 4362                       eject 
0404 4362              **************************************************
0405 4362              *                                                *
0406 4362              *  verify             Verify the current track   *
0407 4362              *                                                *
0408 4362              *                                                *
0409 4362              **************************************************
0410 4362              VERIFY   EQU   *
0411 4362 5C 9F 0F E1           JMP   VerifyHook
0412 4366              *
0413 4366              * Wait out the write recovery time
0414 4366 A9 02        Verify~GCR LDA   #2
0415 4368 20 62 4A              JSR   waitms
0416 436B              *
0417 436B AD 2C 0F              LDA   curnsect                 ;Set up a counter
0418 436E 85 5B                 STA   temp2
0419 4370              *
0420 4370              * Find and interpret an address field
0421 4370 20 4F 4C     VFYA     JSR   rdaddr                   ;this could destory temp2 if drive not Ready!!!!
0422 4373 B0 20                 BCS   vererr                   ;If cs/bs/TO/Offline error
0423 4375              *
0424 4375              * Have we already seen this sector?
0425 4375 AE 33 0F              LDX   sectfnd                  ;Which one is this
0426 4378 EC 2C 0F              CPX   curnsect                 ;Is it too big?
0427 437B B0 18                 BGE   vererr                   ;Yes- some problem
0428 437D              *
0429 437D BD 00 0F              LDA   xlvtab,x                 ;See if we've marked it before
0430 4380 30 13                 BMI   vererr                   ;If so, blew it
0431 4382              *
0432 4382              * Mark this sector as having been seen
0433 4382 A9 FF                 LDA   #$FF
0434 4384 9D 00 0F              STA   xlvtab,x
0435 4387              *
0436 4387              * Now check the data field
0437 4387 9C 42 0F     @GCR     STZ   DRswtch                  ;always verify to indirect buffr
0438 438A 20 D9 4C     @MFM     JSR   readdata
0439 438D B0 06                 BCS   vererr                   ;Return bad if problem
0440 438F              *
0441 438F              * More to do?
0442 438F C6 5B                 DEC   temp2
0443 4391 D0 DD                 BNE   vfya
0444 4393              *
0445 4393 18                    CLC   
0446 4394 60                    RTS                            ;Good exit
0447 4395              *
0448 4395                       NOP   
0449 4395 38           VERERR   SEC   
0450 4396 60           rts55    RTS                            ;Error exit 
0451 4397
0452 4397                       TITLE 'GETFORMAT OPTIONS'
0453 4397              ****************************************************
0454 4397              * DoGetFmt   (local 3.5" units)
0455 4397              *
0456 4397              *  Return a list of format options or Offline err
0457 4397              *
0458 4397              *  input : xfrcnt says how big is output buffr is
0459 4397              *
0460 4397              *  Output: like a status command (a buffer of data)
0461 4397              ****************************************************
0462 4397              GETFMTOPT EQU   *
0463 4397 18                    CLC                            ;no wp errs please
0464 4398 20 05 4A              JSR   SensnChk                 ;do I have a media online?
0465 439B 90 05                 BCC   @20                      ;no 'error' 
0466 439D 50 03                 BVC   @20                      ;ignore dsw error
0467 439F 82 CD F8     @ERR1    BRL   set_err                  ;return Offline error
0468 43A2 10 11        @20      BPL   @30                      ;online known volume
0469 43A4 20 68 47              JSR   MountVol                 ;re-mount volume if possible!
0470 43A7 90 0C                 BCC   @30                      ;vol was known type (reformating!)
0471 43A9 C9 2F                 CMP   #offline                 ;it went offline between Sens & mount??
0472 43AB F0 F2                 BEQ   @err1                    ;yep. boy that was funny
0473 43AD 80 06                 BRA   @30                      ;it was I/O error after DIP
0474 43AF E2 30        @PCERR   SEP   #$30
0475 43B1 A9 22                 LDA   #bcparmcnt
0476 43B3 80 EA                 BRA   @err1
0477 43B5              *
0478 43B5              @30      EQU   *
0479 43B5                       LONGI ON
0480 43B5 C2 10                 REP   #$10
0481 43B7 A4 48                 LDY   cmdcount
0482 43B9 88                    DEY   
0483 43BA 30 F3                 BMI   @pcerr                   ;zero or neg is bad count
0484 43BC C0 00 03              CPY   #0768
0485 43BF 90 03                 BCC   @33
0486 43C1 A0 00 02              LDY   #0512
0487 43C4 C0 39 00     @33      CPY   #0057                    ;min is 56 bytes
0488 43C7 90 E6                 BCC   @pcerr
0489 43C9 A9 00                 LDA   #00
0490 43CB 97 42        @35      STA   [cmdbuffl],y             ;pre fill user buffer with zero
0491 43CD 88                    DEY   
0492 43CE D0 FB                 BNE   @35                      ;all but last byte
0493 43D0                       LONGI OFF
0494 43D0 E2 10                 SEP   #$10
0495 43D2
0496 43D2              *
0497 43D2              * now fake GetFmt for 400 & 800 K only
0498 43D2 A9 02        StdMedia LDA   #02
0499 43D4 97 42                 STA   [cmdbuffl],y             ;entry count is 2
0500 43D6 C8                    INY   
0501 43D7 C8                    INY   
0502 43D8 A9 02                 LDA   #02
0503 43DA 97 42                 STA   [cmdbuffl],y             ;display count = 2
0504 43DC C8                    INY   
0505 43DD C8                    INY   
0506 43DE A9 0C                 LDA   #AD800K2
0507 43E0 97 42                 STA   [cmdbuffl],y             ;default refnum
0508 43E2 AE 28 0F              LDX   drive
0509 43E5 BD 3E 0F              LDA   volsts,x                 ;current refnum
0510 43E8 29 1F                 AND   #$1F                     ;extract cur voltype
0511 43EA C8                    INY   
0512 43EB C8                    INY   
0513 43EC 97 42                 STA   [cmdbuffl],y
0514 43EE C2 20                 REP   #$20                     ;a = 16 bits
0515 43F0                       LONGA ON
0516 43F0              *
0517 43F0              * Now create a pointer of build entry
0518 43F0 A9 08 00              LDA   #0008
0519 43F3 18                    CLC   
0520 43F4 65 42                 ADC   cmdbuffl
0521 43F6 85 4F                 STA   csum                     ;use csum as zpg pointer
0522 43F8 E2 20                 SEP   #$20
0523 43FA                       LONGA OFF
0524 43FA A5 44                 LDA   cmdbuffl+2
0525 43FC 90 01                 BCC   @38
0526 43FE 1A                    INC   a
0527 43FF 85 51        @38      STA   csum+2
0528 4401              *
0529 4401              * Now put some entries
0530 4401 A9 0C                 LDA   #AD800K2
0531 4403 20 11 44              JSR   BldFMTentry              ;two entries
0532 4406 A9 02                 LDA   #AD400K
0533 4408 20 11 44              JSR   BldFMTentry              ;one entry
0534 440B A2 38                 LDX   #3*16+8
0535 440D A0 00                 LDY   #00
0536 440F 18                    CLC   
0537 4410 60                    RTS   
0538 4411                       EJECT 
0539 4411              ***************************************************
0540 4411              * BldFMTentry
0541 4411              *
0542 4411              *    Create an entry in the GETFMTOPTS list for the
0543 4411              * Format option given in the A-reg
0544 4411              * and increment the entry pointer by 16 
0545 4411              *
0546 4411              *    Input : A = format option to create
0547 4411              *           csum = pointer to where to put the data
0548 4411              *
0549 4411              *   Output : csum = csum+16
0550 4411              *
0551 4411              ***************************************************
0552 4411              BLDFMTENTRY EQU   *
0553 4411 A0 00                 LDY   #00
0554 4413 87 4F        @01      STA   [csum]                   ;set fmtoption
0555 4415 AA                    TAX   
0556 4416 BF 7A 44 FF           LDA   >FmtFlags,x
0557 441A 29 0F                 AND   #$0F                     ;just flags bits please
0558 441C A0 04                 LDY   #4
0559 441E 97 4F                 STA   [csum],y
0560 4420 BF 7A 44 FF           LDA   >FmtFlags,x
0561 4424 4A                    LSR   a
0562 4425 4A                    LSR   a
0563 4426 4A                    LSR   a
0564 4427 4A                    LSR   a                        ;discard the flag bits
0565 4428 A0 0C                 LDY   #12
0566 442A 97 4F                 STA   [csum],y
0567 442C              ;
0568 442C BF 79 3C FF           LDA   >VolSizeTbl,x
0569 4430 A0 06                 LDY   #06
0570 4432 97 4F                 STA   [csum],y
0571 4434 C8                    INY   
0572 4435 BF 7A 3C FF           LDA   >VolSizeTbl+1,x
0573 4439 97 4F                 STA   [csum],y
0574 443B A0 0B                 LDY   #10+1
0575 443D A9 02                 LDA   #>512
0576 443F 97 4F                 STA   [csum],y
0577 4441 BF 7A 3C FF           LDA   >VolSizeTbl+1,x
0578 4445 4A                    LSR   a
0579 4446 A0 0F                 LDY   #14+1                    ;hi byte first
0580 4448 97 4F                 STA   [csum],y
0581 444A BF 79 3C FF           LDA   >VolSizeTbl,x
0582 444E 6A                    ROR   a                        ;shift in bit from hi byte
0583 444F 88                    DEY   
0584 4450 97 4F                 STA   [csum],y                 ;size in Kbytes = blks/2
0585 4452              *
0586 4452 A5 4F                 LDA   csum
0587 4454 18                    CLC   
0588 4455 69 10                 ADC   #16                      ;= length of 1 entry
0589 4457 85 4F                 STA   csum
0590 4459 90 06                 BCC   @30
0591 445B C2 20                 REP   #$20                     ;a = 16
0592 445D E6 50                 INC   csum+1
0593 445F E2 20                 SEP   #$20
0594 4461              @30      EQU   *
0595 4461 BF 7B 44 FF           LDA   >FmtFlags+1,x            ;related entries to do?
0596 4465 F0 12                 BEQ   @90                      ;no.
0597 4467 AA                    TAX   
0598 4468 A0 02                 LDY   #02
0599 446A B7 42                 LDA   [cmdbuffl],y
0600 446C 1A                    INC   a
0601 446D 97 42                 STA   [cmdbuffl],y
0602 446F A0 00                 LDY   #00
0603 4471 B7 42                 LDA   [cmdbuffl],y
0604 4473 1A                    INC   a
0605 4474 97 42                 STA   [cmdbuffl],y
0606 4476 8A                    TXA   
0607 4477 80 9A                 BRA   @01                      ;stick another entry in
0608 4479 60           @90      RTS   
0609 447A                       EJECT 
0610 447A              ********************************************
0611 447A              * Format option tables
0612 447A              *
0613 447A              * This table contains 3 items in low byte
0614 447A              * Low Byte  b7..b4  = interleave factor n:1
0615 447A              *           b3,b2   = Kbytes format size 
0616 447A              *           b1,b0   = format flags Univ,Appl,NonAppl
0617 447A              * Hi Byte  refnum of related format 
0618 447A              *     0x is alternate interleave format
0619 447A              *
0620 447A              ********************************************
0621 447A              KB       EQU   $04
0622 447A              UNIV     EQU   $00
0623 447A              APPL     EQU   $01
0624 447A              NONAPPL  EQU   $02
0625 447A                                                      ; SEG	code
0626 447A              FMTFLAGS EQU   *
0627 447A                                                      ; SEG	fake_it
0628 447A 00 00        FMTOPT1  DC B:0,0                       ;  0 null
0629 447C 25 00                 DC B:$20+KB+APPL,0             ;  2 AD400K    2:1
0630 447E 45 00                 DC B:$40+KB+APPL,0             ;  4 AD800K    4:1
0631 4480 16 00                 DC B:$10+KB+NONAPPL,0          ;  6 reserved
0632 4482 16 00                 DC B:$10+KB+NONAPPL,0          ;  8 AD720K    1:1  
0633 4484 34 00                 DC B:$30+KB+UNIV,0             ;  A SD1440K   3:1
0634 4486 25 04                 DC B:$20+KB+APPL,$04           ;  C AD800K2   2:1
0635 4488              FOPTMAX  EQU   *-FMTOPT1-1
0636 4488 00 00                 DC W:0000
0637 448A                       EJECT 
0638 448A              ****************************************************
0639 448A              * DoSetFmt
0640 448A              *
0641 448A              *  Set the format option for the next Format command
0642 448A              *
0643 448A              *  INPUT a format option number (0..maxfopt)
0644 448A              *
0645 448A              *  OUTPUT : Error messages for conflicts between the
0646 448A              *           selected option and media density
0647 448A              ****************************************************
0648 448A              SETFMTOPT EQU   *
0649 448A A5 49                 LDA   cmdcount+1               ;hi byte of clist lgth zero?
0650 448C F0 0A                 BEQ   @10                      ;yep.
0651 448E A9 22        @BPCERR  LDA   #bcparmcnt
0652 4490 82 DC F7              BRL   set_err
0653 4493 A9 21        @BCERR   LDA   #coderror
0654 4495 82 D7 F7              BRL   set_err
0655 4498 A5 48        @10      LDA   cmdcount                 ;get clist byte length
0656 449A F0 18                 BEQ   @13                      ;zero parms is default set
0657 449C C9 05                 CMP   #05
0658 449E B0 EE                 BCS   @bpcerr                  ;too much data
0659 44A0 4A                    LSR   a
0660 44A1 B0 EB                 BCS   @bpcerr
0661 44A3 A7 42                 LDA   [cmdbuffl]               ;get fmt option
0662 44A5 C9 0D                 CMP   #foptmax                 ;check parm range
0663 44A7 B0 EA                 BCS   @bcerr                   ;its bad.
0664 44A9 29 01                 AND   #01                      ;is it odd?
0665 44AB D0 E6                 BNE   @bcerr                   ;bad also.
0666 44AD AE 28 0F              LDX   drive                    ;parm in range
0667 44B0 A7 42                 LDA   [cmdbuffl]               ;get the option again
0668 44B2 D0 0A                 BNE   @15                      ;specific fmt requested
0669 44B4 A9 04        @13      LDA   #AD800K
0670 44B6 9D 52 0F              STA   FmtOption,x
0671 44B9 20 EE 44              JSR   ResetFmt                 ;reset to defaults
0672 44BC 80 2E                 BRA   @20                      ;and reply 'ok'
0673 44BE A0 80        @15      LDY   #$80
0674 44C0 8C 50 0F              STY   formsides                ;assume double sided
0675 44C3 C9 02                 CMP   #AD400K                  ;is it single sided?
0676 44C5 D0 03                 BNE   @17
0677 44C7 9C 50 0F              STZ   formsides
0678 44CA              @17      EQU   *
0679 44CA 9D 52 0F              STA   FmtOption,x
0680 44CD AA                    TAX   
0681 44CE BF 7A 44 FF           LDA   >FmtFlags,x              ;get interleave from table
0682 44D2 4A                    LSR   a
0683 44D3 4A                    LSR   a
0684 44D4 4A                    LSR   a
0685 44D5 4A                    LSR   a
0686 44D6 8D 4F 0F              STA   Interleave               ;set interleave from tbl
0687 44D9 A5 48                 LDA   cmdcount                 ;does clist include 2nd parm?
0688 44DB C9 04                 CMP   #04
0689 44DD 90 0D                 BCC   @20                      ;nope. 
0690 44DF A0 02                 LDY   #02                      ;offset to interleave
0691 44E1 B7 42                 LDA   [cmdbuffl],y             ;get interleave override
0692 44E3 F0 07                 BEQ   @20                      ;nope.
0693 44E5 C9 09                 CMP   #8+1
0694 44E7 B0 A5                 BCS   @bpcerr
0695 44E9 8D 4F 0F              STA   Interleave               ;use callers override interleave
0696 44EC              @20      EQU   *
0697 44EC 18           @30      CLC   
0698 44ED 60                    RTS   
0699 44EE              ************************************************
0700 44EE              * ResetFmt
0701 44EE              ************************************************
0702 44EE              RESETFMT EQU   *
0703 44EE BD 52 0F              LDA   FmtOption,x              ;was SetFmt option used?
0704 44F1 F0 0D                 BEQ   @10                      	;no. leave interleave,sides alone
0705 44F3 A9 80                 LDA   #$80
0706 44F5 8D 50 0F              STA   Formsides                	;default GCR is DS & 4:1
0707 44F8 A9 04                 LDA   #04
0708 44FA 8D 4F 0F              STA   Interleave
0709 44FD 9E 52 0F              STZ   FmtOption,x              ;zero means use default
0710 4500 60           @10      RTS   
0711 4501                       TITLE 'Control Request Handler'
0712 4501              ****************************************************************
0713 4501              *                                                              *
0714 4501              *  Control                       Handles a control request     *
0715 4501              *                                                              *
0716 4501              ****************************************************************
0717 4501              *
0718 4501              CONTROL  EQU   *
0719 4501 A5 48                 LDA   CMDSCode                 ;Get the control code
0720 4503 C9 0B                 CMP   #nccodes                 ;Check for boundary
0721 4505 90 05                 BLT   ctrlokay                 ;It's within range
0722 4507              *
0723 4507              ILLCODE  EQU   *
0724 4507 A9 21                 LDA   #coderror                ;Bad control code
0725 4509 82 63 F7              BRL   set_err                  ; mark an error
0726 450C              *
0727 450C              * Code is okay... do the multi-way branch
0728 450C              *
0729 450C              CTRLOKAY EQU   *
0730 450C 0A                    ASL   a
0731 450D AA                    TAX   
0732 450E BF 1A 45 FF           LDA   >cctable+1,x
0733 4512 48                    PHA   
0734 4513 BF 19 45 FF           LDA   >cctable,x
0735 4517 48                    PHA   
0736 4518 60                    RTS   
0737 4519              *
0738 4519                                                      ; SEG	code	;
0739 4519              CCTABLE  EQU   *
0740 4519 31 45                 DC W:CTRLRESET-1
0741 451B 2E 45                 DC W:ILLCTRL-1
0742 451D 2E 45                 DC W:ILLCTRL-1                 ;Char dev only
0743 451F 2E 45                 DC W:ILLCTRL-1                 ;Not interrupt driven
0744 4521 3E 45                 DC W:CTRLEJECT-1               ;Drive eject
0745 4523 A7 45                 DC W:HOOKSET-1                 ; set hook address
0746 4525 06 46                 DC W:HOOKRES-1                 ; reset hook address to default
0747 4527 2F 46                 DC W:MARKSET-1                 ; Set mark table bytes
0748 4529 46 46                 DC W:MARKRES-1                 ; reset mark table bytes
0749 452B 7B 46                 DC W:SETSIDES-1                ; set single or double sided
0750 452D 8C 46                 DC W:SETXLV-1                  ; set interleave
0751 452F                                                      ; SEG	fake_it	;
0752 452F              *
0753 452F              CTRLTEND EQU   *
0754 452F              NCCODES  EQU   (CTRLTEND-CCTABLE)/2
0755 452F              *
0756 452F              *
0757 452F              ILLCTRL  EQU   *
0758 452F 4C 07 45              JMP   IllCode
0759 4532              *
0760 4532              *
0761 4532              CTRLRESET EQU   *
0762 4532 20 41 3C              JSR   initformat               ; make it double sided, interleave 4:1
0763 4535 20 52 3C              JSR   InitHooks
0764 4538 4C 60 3C              JMP   Initmarks                ; set up mark tables
0765 453B              *
0766 453B              CTRLSETDCB EQU   *
0767 453B 4C 07 45              JMP   illcode                  ; not good
0768 453E 60                    RTS                            ;Pull the command packet
0769 453F              * 
0770 453F              CTRLEJECT EQU   *
0771 453F AE 28 0F              LDX   drive
0772 4542 20 CF 49              JSR   EnblnSens                ;enable the drive and set sense bits
0773 4545 20 AE 48              JSR   Eject                    ;Do the eject
0774 4548              * stz diskreg ;remove /ENBL35
0775 4548 60                    RTS   
0776 4549
0777 4549                       TITLE 'Define the Device ID'
0778 4549              *****************************************************************
0779 4549              *                                                               *
0780 4549              *  Init                             Define the device UnitID    *
0781 4549              *                                                               *
0782 4549              *   Assign the UnitNo in CmdId to the next available drive      *
0783 4549              *   If all Devices are assigned the return a soft error for     *
0784 4549              *   SmartPort initialization processing                         *
0785 4549              *                                                               *
0786 4549              *****************************************************************
0787 4549              INITCMD  EQU   *
0788 4549 AD 39 0F              LDA   DrvToAssign              ;If all assigned return error
0789 454C F0 10                 BEQ   @30                      ;yep already done.
0790 454E              *
0791 454E A0 00                 LDY   #00
0792 4550 B9 20 0F     @10      LDA   UnitId,y
0793 4553 F0 04                 BEQ   @20                      ; no drive 
0794 4555 C9 40                 CMP   #$40                     ; is this drive assigned?
0795 4557 B0 0B                 BCS   @40                      ;no so assign it and exit
0796 4559 C8           @20      INY   
0797 455A C0 02                 CPY   #maxdrivs
0798 455C 90 F2                 BCC   @10                      ;try next drive
0799 455E              *
0800 455E              @30      EQU   *
0801 455E A9 40                 LDA   #lasterror               ;thisis a 'soft' error to SmartPort
0802 4560 8D 4B 0F              STA   statbyte
0803 4563 60                    RTS   
0804 4564              *
0805 4564 A5 4E        @40      LDA   cmdUnit
0806 4566 99 20 0F              STA   UnitID,y
0807 4569 CE 39 0F              DEC   DrvToAssign              ;count this one
0808 456C 60                    RTS                            ;
0809 456D                       TITLE 'Miscellaneous Commands'
0810 456D              *****************************************************************
0811 456D              *
0812 456D              * Macread: This will map a protocol converter read call into a
0813 456D              *          a 524 byte block read call.
0814 456D              *
0815 456D              *****************************************************************
0816 456D              MACREAD  EQU   *
0817 456D 20 8F 45              JSR   MovBlkNo                 ;Blknum not quite where we want
0818 4570 B0 35                 BCS   return                   ;count not = 524
0819 4572 A9 01                 LDA   #CMDRead                 ;Make it look like a reg'ler read
0820 4574 85 45                 STA   CMDCode
0821 4576 A9 FF                 LDA   #$FF                     ; mark a mac command
0822 4578 8D 51 0F              STA   mac_flag                 ; (doesn't work for MFM disks)
0823 457B 4C C7 3F              JMP   ReadBlk                  ;Do a read of the block in question
0824 457E              *****************************************************************
0825 457E              *
0826 457E              * Macwrite: This routine will  map a protocol converter write call
0827 457E              *           into a 524 byte block write call.  
0828 457E              *
0829 457E              *****************************************************************
0830 457E              MACWRITE EQU   *
0831 457E 20 8F 45              JSR   MovBlkNo                 ;Move blknum to the regular place
0832 4581 B0 24                 BCS   return                   ;count not = 524!!
0833 4583 A9 02                 LDA   #CMDWrite
0834 4585 85 45                 STA   CMDCode                  ;This is really a write
0835 4587 A9 FF                 LDA   #$FF                     ; mark a Mac write command
0836 4589 8D 51 0F              STA   mac_flag                 ; (doesn't work for MFM disks)
0837 458C 4C CA 3F              JMP   WriteBlk                 ;Do a write of the block in question
0838 458F              *****************************************************************
0839 458F              *
0840 458F              * Movblkno: This routine will discard the two byte count parameter
0841 458F              *           associated with the read or write call.  The block number
0842 458F              *           will be shifted up two byte and overwrite the count.
0843 458F              *
0844 458F              *****************************************************************
0845 458F              MOVBLKNO EQU   *
0846 458F A5 49                 LDA   cmdcount+1
0847 4591 C9 02                 CMP   #>524
0848 4593 D0 6D                 BNE   bhpcount
0849 4595 A5 48                 LDA   cmdcount
0850 4597 C9 0C                 CMP   #<524
0851 4599 D0 67                 BNE   bhpcount
0852 459B A2 00                 LDX   #$00                     ; reset counter
0853 459D              MBN1     EQU   *
0854 459D B5 4A                 LDA   cmdadrs,x                ; throw away byte count
0855 459F 95 48                 STA   cmdblockl,x
0856 45A1 E8                    INX                            ; next byte
0857 45A2 E0 04                 CPX   #$04                     ; 4 bytes moved
0858 45A4 90 F7                 BLT   mbn1                     ;
0859 45A6 18                    CLC   
0860 45A7              RETURN   EQU   *                        ;
0861 45A7 60                    RTS   
0862 45A8                       TITLE 'Hook set/reset routines'
0863 45A8              *****************************************************************
0864 45A8              *
0865 45A8              * Hook.set: This routine will set the address field corresponding to a
0866 45A8              *           hook  number in the firmware of the Dsony drive to a specific
0867 45A8              *           value.  The contents of the control call parameter list is
0868 45A8              *           as follows:
0869 45A8              *
0870 45A8              *                $XXYY +-------------+        Control call # = $05
0871 45A8              *                      |  count.low  |
0872 45A8              *                      +- - - - - - -+
0873 45A8              *                      |  count.high |
0874 45A8              *                      +-------------+
0875 45A8              *                      | Hook number |
0876 45A8              *                      +-------------+
0877 45A8              *                      |   addr.low  |
0878 45A8              *                      +- - - - - - -+
0879 45A8              *                      |   addr.med. |
0880 45A8              *                      +- - - - - - -+
0881 45A8              *                      |  addr.high  |
0882 45A8              *                      +-------------+
0883 45A8              *
0884 45A8              *****************************************************************
0885 45A8              HOOKSET  EQU   *                        ;
0886 45A8 A9 04                 LDA   #$04                     ; 4 bytes of parameter
0887 45AA 20 F1 45              JSR   chk_hpbounds             ;
0888 45AD B0 52                 BCS   exit_chk_hpbound         ; something went wrong go away
0889 45AF B7 42                 LDA   [cmdbuffl],y             ; get the hook #
0890 45B1 48                    PHA                            ; save it
0891 45B2 29 7F                 AND   #$7F                     ; mask off upper bit
0892 45B4 F0 35                 BEQ   bad_hook                 ; 0 < hook < maxhook+1
0893 45B6 3A                    DEC   A                        ; point to beginning of ram
0894 45B7 C9 08                 CMP   #maxhook                 ; and make sure it is in range
0895 45B9 B0 30                 BGE   bad_hook                 ; if not, let world know
0896 45BB 0A                    ASL   A                        ; hook number times 8 points
0897 45BC 0A                    ASL   A                        ; to start area of hook+1
0898 45BD 0A                    ASL   A                        ;
0899 45BE AA                    TAX                            ; point to the hook table entry
0900 45BF A9 22                 LDA   #$22                     ; replace jmp long with jsl
0901 45C1 9F 6F 0F E1           STA   hooks+2,x                ; put it in the table
0902 45C5 80 06                 BRA   seth_loop_1              ; put it in the table
0903 45C7              SETH_LOOP EQU   *
0904 45C7 B7 42                 LDA   [cmdbuffl],y             ; get the byte
0905 45C9 9F 6F 0F E1           STA   hooks+2,x                ; and put it in the table
0906 45CD E8           SETH_LOOP_1 INX                         ; point to next hook table byte
0907 45CE C8                    INY                            ; point to next parameter byte
0908 45CF C0 06                 CPY   #$06                     ; all bytes moved?
0909 45D1 90 F4                 BLT   seth_loop                ; move three bytes
0910 45D3 68                    PLA                            ; restore hook number
0911 45D4 10 12                 BPL   exit_hook_setup          ; all done he wants to fall into my code
0912 45D6 A9 FF                 LDA   #^return                 ; force a return
0913 45D8 9F 72 0F E1           STA   hooks+5,x                ; point to bank $FF
0914 45DC A9 A7                 LDA   #<return                 ; low byte of return address
0915 45DE 9F 70 0F E1           STA   hooks+3,x                ;
0916 45E2 A9 45                 LDA   #>return                 ; high byte of return address
0917 45E4 9F 71 0F E1           STA   hooks+4,x                ;
0918 45E8 82 12 00     EXIT_HOOK_SETUP BRL   good_exit         ; mark success
0919 45EB              ;
0920 45EB              BAD_HOOK EQU   *
0921 45EB 68                    PLA                            ; discard hook number
0922 45EC A9 30                 LDA   #bhook_err               ; bad hook number error
0923 45EE 82 7E F6              BRL   set_err                  ; tell the world
0924 45F1                       TITLE 'Check set.res.hook param count'
0925 45F1              ***************************************************
0926 45F1              * Chk.hpbounds: This routine will check the parameter count for
0927 45F1              *             the set hook and reset hook calls.
0928 45F1              *
0929 45F1              *     Import: A = compare value
0930 45F1              *     Export: (Y) points to hook number in [cmdbuffl]
0931 45F1              *
0932 45F1              ***************************************************
0933 45F1              CHK_HPBOUNDS EQU   *                    ;
0934 45F1 A0 00                 LDY   #$00                     ; point to low byte of count
0935 45F3 D7 42                 CMP   [cmdbuffl],y             ;
0936 45F5 D0 0B                 BNE   bhpcount                 ; bad parameter count
0937 45F7 C8                    INY                            ; bump to high byte of count
0938 45F8 B7 42                 LDA   [cmdbuffl],y             ; must be zero
0939 45FA D0 06                 BNE   bhpcount                 ; non zero = bad news
0940 45FC C8                    INY                            ; point to hook number
0941 45FD 18           GOOD_EXIT: CLC                          ; mark success
0942 45FE 9C 4B 0F              STZ   statbyte                 ;
0943 4601 60           EXIT_CHK_HPBOUND RTS                    ; >>>--- exit chk.hpbounds --->>>
0944 4602 A9 22        BHPCOUNT LDA   #bcparmcnt               ; bad control param count
0945 4604 82 68 F6              BRL   set_err                  ;
0946 4607              ***************************************************
0947 4607              *
0948 4607              * Hook.res: This routine will restore a firmware hook to its firmware
0949 4607              *            default.
0950 4607              *
0951 4607              *     Import: parameter list
0952 4607              *             
0953 4607              *             +-------------+        Control call # = $06
0954 4607              *             | Hook number |
0955 4607              *             +-------------+
0956 4607              *
0957 4607              ***************************************************
0958 4607              HOOKRES  EQU   *                        ;
0959 4607 A9 04                 LDA   #$04                     ; 4 bytes of parameter
0960 4609 20 F1 45              JSR   chk_hpbounds             ;
0961 460C B0 F3                 BCS   exit_chk_hpbound         ; something went wrong go away
0962 460E B7 42                 LDA   [cmdbuffl],y             ; get the hook #
0963 4610 F0 19                 BEQ   res_hooks                ; hook #0 resets all hooks
0964 4612 C9 09                 CMP   #maxhook+1               ; and make sure it is in range
0965 4614 B0 D5                 BGE   bad_hook                 ; if not, let world know
0966 4616 0A                    ASL   A                        ; times 8 points
0967 4617 0A                    ASL   A                        ; to table entry
0968 4618 0A                    ASL   A                        ;
0969 4619 1A                    INC   A                        ; point to end of hook
0970 461A AA                    TAX                            ; point to start of address
0971 461B A0 08                 LDY   #$08
0972 461D BF 02 3E FF  RESETH_LOOP LDA   >hooktab,x            ; get the byte
0973 4621 9F 6D 0F E1           STA   hooks,x                  ; and put it in the table
0974 4625 CA                    DEX                            ; decrement count
0975 4626 88                    DEY                            ; decrement count
0976 4627 D0 F4                 BNE   reseth_loop              ; move three bytes
0977 4629 80 BD                 BRA   exit_hook_setup          ; >>>>---- exit resethook ---->>>>
0978 462B              ;
0979 462B              RES_HOOKS EQU   *                       ; hook # = 0 reset all hooks
0980 462B 20 52 3C              JSR   inithooks                ;
0981 462E 80 B8                 BRA   exit_hook_setup          ;
0982 4630                       TITLE 'Hook set/reset routines'
0983 4630              ***************************************************
0984 4630              * Mark.set: This routine will allow the caller to set a specific
0985 4630              *           number of bytes in the mark tables to specific values.
0986 4630              *           The count field will be used to determine how many
0987 4630              *           bytes need to be moved to the mark tables. The count
0988 4630              *           field is required by the protocol converter.  The count
0989 4630              *           minus one will equal the number of bytes to move.
0990 4630              *
0991 4630              *     Import:
0992 4630              *              (Temp) = byte count, from chk.bounds subroutine
0993 4630              *            Ctrllist: +----------+        Control call # = $07
0994 4630              *                      | count lo | = $XX
0995 4630              *                      +----------+
0996 4630              *                      | count hi | = $00
0997 4630              *                      +----------+
0998 4630              *                      |start byte|
0999 4630              *                      +----------+
1000 4630              *                      |   data   |
1001 4630              *                      +----------+
1002 4630              *                      |   data   |
1003 4630              *                      +----------+
1004 4630              *                      |   data   |
1005 4630              *                      +----------+
1006 4630              *                        . . . .
1007 4630              *                        . . . .
1008 4630              *
1009 4630              *     Export:
1010 4630              *             A, X, Y = trash
1011 4630              *             (Temp) = $00
1012 4630              *
1013 4630              ***************************************************
1014 4630              MARKSET  EQU   *                        ;
1015 4630 20 5E 46              JSR   chk_bounds               ; make sure starting location ok & size ok
1016 4633 B0 0F                 BCS   exit_Mset                ; something wrong, go away
1017 4635 B7 42                 LDA   [cmdbuffl],y             ; get start pointer
1018 4637 AA                    TAX                            ; point to mark table location
1019 4638 C8                    INY                            ; point to 1st data byte
1020 4639 B7 42        SM_LOOP  LDA   [cmdbuffl],y             ; get data byte
1021 463B 9D 57 0F              STA   marktab,x                ;
1022 463E C8                    INY                            ; bump source pointer
1023 463F E8                    INX                            ; bump destination
1024 4640 C6 5A                 DEC   temp                     ; decrement count
1025 4642 D0 F5                 BNE   sm_loop                  ;
1026 4644 82 B6 FF     EXIT_MSET BRL   good_exit               ; everybody happy
1027 4647                       EJECT 
1028 4647              ***************************************************
1029 4647              *
1030 4647              * Mark.res: This routine will reset a specified number of bytes in
1031 4647              *           the mark tables to their rom default values.
1032 4647              *
1033 4647              *
1034 4647              *     Import:
1035 4647              *               (Temp) = byte count, from Chk.bounds subroutine
1036 4647              *            Ctrllist: +----------+        Control call # = $08 
1037 4647              *                      | count lo | = $XX
1038 4647              *                      +----------+
1039 4647              *                      | count hi | = $00
1040 4647              *                      +----------+
1041 4647              *                      |start byte|
1042 4647              *                      +----------+
1043 4647              *
1044 4647              *     Export:
1045 4647              *             A, X, Y = trash
1046 4647              *             (Temp) = $00
1047 4647              *
1048 4647              ***************************************************
1049 4647              MARKRES  EQU   *                        ;
1050 4647 20 5E 46              JSR   chk_bounds               ; make sure starting location ok & size ok
1051 464A B0 0F                 BCS   exit_mres                ; something wrong, go away
1052 464C B7 42                 LDA   [cmdbuffl],y             ; get pointer to first byte to change
1053 464E AA                    TAX                            ;
1054 464F BF 44 3E FF  RM_LOOP  LDA   >Marktabvals,x           ; get mark table byte
1055 4653 9D 57 0F              STA   Marktab,x                ; place it in ram based table
1056 4656 E8                    INX                            ; point to next lower byte
1057 4657 C6 5A                 DEC   temp                     ; decrement byte count
1058 4659 D0 F4                 BNE   rm_loop                  ;
1059 465B 82 9F FF     EXIT_MRES BRL   good_exit               ;
1060 465E                       TITLE 'Bounds check for set & reset mark'
1061 465E              ***************************************************
1062 465E              *
1063 465E              * Chk.bounds: This routine will check the starting location against
1064 465E              *             number of bytes to be moved into the mark table to
1065 465E              *             make sure that we are within range.
1066 465E              *
1067 465E              *     Import: None
1068 465E              *     Export: A = index to last byte to be accessed
1069 465E              *     Export: C = 0, statbyte = 0 for success
1070 465E              *             C = 1, statbyte = $31 for range error
1071 465E              *             (Temp) = byte count
1072 465E              *
1073 465E              ***************************************************
1074 465E              CHK_BOUNDS EQU   *                      ;
1075 465E A0 01                 LDY   #$01                     ; point to beginning of parameter list
1076 4660 B7 42                 LDA   [cmdbuffl],y             ; upper byte must be zero
1077 4662 D0 0F                 BNE   invbcount                ; too many bytes
1078 4664 88                    DEY                            ; point to low byte of count
1079 4665 B7 42                 LDA   [cmdbuffl],y             ;
1080 4667 3A                    DEC   A                        ; byte count to move = count - 1
1081 4668 85 5A                 STA   temp                     ; save the count
1082 466A A0 02                 LDY   #$02                     ; point past the count
1083 466C 18                    CLC                            ;
1084 466D 77 42                 ADC   [cmdbuffl],y             ; add starting byte
1085 466F C9 17                 CMP   #marktablen+1            ; and messed up if greater than
1086 4671 90 05                 BLT   mbok                     ; mark bounds ok
1087 4673 A9 22        INVBCOUNT LDA   #bcparmcnt              ; mark a parameter count error
1088 4675 82 F7 F5              BRL   set_err                  ;
1089 4678              ;
1090 4678              MBOK     EQU   *                        ;
1091 4678 9C 4B 0F              STZ   statbyte                 ; everybody happy
1092 467B 60                    RTS                            ; >>>--- exit check bounds --->>>
1093 467C              ***************************************************
1094 467C              *
1095 467C              * Set.sides: This routine will allow the caller to set the type
1096 467C              *            of media inserted into the drive.  By being able to
1097 467C              *            change, one can format single sided disks in a double
1098 467C              *            sided drive.
1099 467C              *
1100 467C              *     Import: +---------+          Control call # = $09
1101 467C              *             | countl  | = $01
1102 467C              *             +---------+
1103 467C              *             | counth  | = $00
1104 467C              *             +---------+
1105 467C              *             |  sides  | single = %0xxxxxxx, double = %1xxxxxxx
1106 467C              *             +---------+
1107 467C              *
1108 467C              *    Export: C = 0, statbyte = 0
1109 467C              *             A,X,Y trashed 
1110 467C              *
1111 467C              ***************************************************
1112 467C              SETSIDES EQU   *                        ;
1113 467C A9 01                 LDA   #$01                     ; 1 parameter byte
1114 467E 20 F1 45              JSR   chk_hpbounds             ; check for 1 byte
1115 4681 B0 F0                 BCS   invbcount                ; invalid count
1116 4683 B7 42                 LDA   [cmdbuffl],y             ; get the number of sides
1117 4685 29 80                 AND   #$80                     ; bit 7 = sides bit
1118 4687 8D 50 0F              STA   formsides                ; save number of sides
1119 468A 82 70 FF              BRL   good_exit                ; mark success
1120 468D                       EJECT 
1121 468D              ***************************************************
1122 468D              *
1123 468D              * Setxlv: This routine will allow the caller to change the interleave
1124 468D              *         between 1 & 12 inclusive.
1125 468D              *
1126 468D              *
1127 468D              *     Import:
1128 468D              *            Ctrllist: +----------+        Control call # = $0A
1129 468D              *                      | count lo |
1130 468D              *                      +----------+
1131 468D              *                      | count hi |
1132 468D              *                      +----------+
1133 468D              *                      |Interleave|
1134 468D              *                      +----------+
1135 468D              *
1136 468D              ***************************************************
1137 468D              SETXLV   EQU   *
1138 468D A9 01                 LDA   #$01                     ; 1 byte of parameter
1139 468F 20 F1 45              JSR   chk_hpbounds             ; check bounds
1140 4692 B0 DF                 BCS   invbcount                ; error if more than one byte
1141 4694 B7 42                 LDA   [cmdbuffl],y             ; get the interleave
1142 4696 F0 0A                 BEQ   xlverror                 ; 0< xlv <13
1143 4698 C9 09                 CMP   #maxxlv+1                ; check for the max interleave
1144 469A B0 06                 BGE   xlverror                 ; greater than 12, something is wrong
1145 469C 8D 4F 0F              STA   interleave               ; set new interleave
1146 469F 82 5B FF              BRL   good_exit                ; everybody happy
1147 46A2              ;
1148 46A2              XLVERROR EQU   *                        ;
1149 46A2 A9 32                 LDA   #xlv_err                 ; mark an interleave error
1150 46A4 82 C8 F5              BRL   set_err                  ;
1151 46A7                       TITLE 'Get variable area pointer'
1152 46A7              ***************************************************
1153 46A7              *
1154 46A7              * Get.vars: This routine will return the start of the variable
1155 46A7              *           area for the unified drive.  This routine is called
1156 46A7              *           as a user defined control call in smartport.   
1157 46A7              *
1158 46A7              ***************************************************
1159 46A7              GET_VARS EQU   *                        ;
1160 46A7 18                    CLC                            ; native mode
1161 46A8 FB                    XCE                            ;
1162 46A9 08                    PHP                            ; save e, m, x 
1163 46AA                       LONGA ON
1164 46AA                       LONGI ON
1165 46AA C2 30                 REP   #$30                     ;
1166 46AC A0 00 00              LDY   #$0000                   ; destination index
1167 46AF A9 1E 0F              LDA   #vars_area               ; return the variables
1168 46B2 97 42                 STA   [cmdbuffl],y             ; save it away
1169 46B4 C8                    INY                            ; bump index
1170 46B5 C8                    INY                            ;
1171 46B6 A9 E1 00              LDA   #data_bank               ; save the variables data bank
1172 46B9 97 42                 STA   [cmdbuffl],y             ;
1173 46BB                       LONGA OFF                      	;
1174 46BB                       LONGI OFF                      	;
1175 46BB              EXIT_GV  EQU   *                        ; Get.buff.addr exits here
1176 46BB 28                    PLP                            ; restore e, m, x
1177 46BC C8                    INY                            ; byte count returned
1178 46BD C8                    INY                            ;
1179 46BE BB                    TYX                            ; x = low count
1180 46BF A0 00                 LDY   #$00                     ; y = high count
1181 46C1 9C 4B 0F              STZ   statbyte                 ; mark success
1182 46C4 FB                    XCE                            ;
1183 46C5 18                    CLC                            ; mark success
1184 46C6 60                    RTS   
1185 46C7              ***************************************************
1186 46C7              *
1187 46C7              * Get.buff.addr: This routine will return the address of the
1188 46C7              *                unified firmware data buffers.
1189 46C7              *
1190 46C7              ***************************************************
1191 46C7              GET_BUFF_ADDR EQU   *                   ;
1192 46C7 18                    CLC                            ; native mode
1193 46C8 FB                    XCE                            ;
1194 46C9 08                    PHP                            ; save e, m, x 
1195 46CA                       LONGA ON
1196 46CA                       LONGI ON
1197 46CA C2 30                 REP   #$30                     ;
1198 46CC A0 00 00              LDY   #$0000                   ; destination index
1199 46CF A9 00 0C              LDA   #sectbuf                 ; buffer start address
1200 46D2 97 42                 STA   [cmdbuffl],y             ; save it away
1201 46D4 C8                    INY                            ; bump index
1202 46D5 C8                    INY                            ;
1203 46D6 A9 E1 00              LDA   #data_bank               ; save the variables data bank
1204 46D9 97 42                 STA   [cmdbuffl],y             ;
1205 46DB 80 DE                 BRA   exit_gv
1206 46DD                       LONGA OFF
1207 46DD                       LONGI OFF
1208 46DD              *
1209 46DD                       TITLE 'Hardware registers setup routine'
1210 46DD              *******************************************************************
1211 46DD              *
1212 46DD              * Regs.setup: This routine sets up the data bank register, the disk
1213 46DD              *             register, the CYA register and the command byte will
1214 46DD              *             be checked for a possible extended command.  If the
1215 46DD              *             command is an extended command then a flag will be
1216 46DD              *             set and the extended command bit in the command byte
1217 46DD              *             will be cleared.
1218 46DD              *
1219 46DD              *     Import: None
1220 46DD              *     Export: D = $E1 data bank
1221 46DD              *             Disk reg = $40 (enable 3.5 asserted)
1222 46DD              *              CYA reg = 10XXXXXX (fast, NO motor slowdown)
1223 46DD              *
1224 46DD              *******************************************************************
1225 46DD              REGS_SETUP EQU   *                      ;
1226 46DD A9 E1                 LDA   #data_bank               ; point to my data bank
1227 46DF 48                    PHA                            ;
1228 46E0 AB                    PLB                            ;
1229 46E1 AD 36 C0              LDA   cyareg                   ; must be preserved by caller (SmartPort Mgr)
1230 46E4 29 FB                 AND   #$FB                     ; no motor detect
1231 46E6 09 80                 ORA   #$80                     ; and fast
1232 46E8 8D 36 C0              STA   cyareg                   ; put it back
1233 46EB 86 4E                 STX   cmdUnit                  ; save destination unitno
1234 46ED A9 40                 LDA   #$40                     ; enable sony 3.5 drives
1235 46EF 8D 31 C0              STA   diskreg                  ; asserts EN3.5 to active (low state)
1236 46F2 A5 45                 LDA   cmdcode                  ; get the command
1237 46F4 29 40                 AND   #ext_cmd                 ; save possible extended bit
1238 46F6 8D 1E 0F              STA   ext_flag                 ;
1239 46F9 A5 45                 LDA   cmdcode                  ; clear extended command bit
1240 46FB 29 BF                 AND   #$BF                     ;
1241 46FD 85 45                 STA   cmdcode                  ;
1242 46FF                       IF 1 THEN
1243 46FF A2 0B                 LDX   #11
1244 4701 B5 42        @CPYCT   LDA   cmdtab,x
1245 4703 9D 12 0F              STA   stssav,x
1246 4706 CA                    DEX   
1247 4707 10 F8                 BPL   @cpyct                   ;sav a copy for debugging
1248 4709 A5 4E                 LDA   cmdUnit
1249 470B 8D 17 0F              STA   stssav+5                 ;save unit in the 12 bytes
1250 470E                       ENDIF 
1251 470E A9 0F                 LDA   #$0F                     ;7 Mhz no timer fast asynch latch 
1252 4710              *  fall thru to SetIWMmode 
1253 4710              **************************************************************
1254 4710              *
1255 4710              * Enter setIWMmode with A set to the IWM mode desired
1256 4710              *
1257 4710              *     INPUT :   A = needed IWM mode
1258 4710              *    OUTPUT :   Y = input A reg
1259 4710              *    Destorys   A
1260 4710              *    Preserves  X
1261 4710              *
1262 4710              **************************************************************
1263 4710              SETIWMMODE EQU   *
1264 4710 A8                    TAY                            ;Preserve the mode byte 
1265 4711 2C E8 C0              BIT   DeSelect                 ;deactivate the enables
1266 4714 2C ED C0              BIT   l6set                    ;setup for StatusRd and ModeWr
1267 4717 AD EE C0     @05      LDA   l7clr                    ; get the status reg
1268 471A 29 20                 AND   #$20
1269 471C D0 F9                 BNE   @05                      ;wait for enable's to drop
1270 471E 80 03                 BRA   @20
1271 4720 8C EF C0     @10      STY   l7set                    ;write the mode register
1272 4723 98           @20      TYA   
1273 4724 4D EE C0              EOR   l7clr                    ;compare with low 5 bits of status reg
1274 4727 29 1F                 AND   #$1F                     ;mask off upper 3 bits
1275 4729 D0 F5                 BNE   @10                      ;try again if it doesn't match
1276 472B AD EC C0              LDA   l6clr                    ;return to read state
1277 472E 60                    RTS   
1278 472F
1279 472F                       TITLE 'Survey GCR Volume Type'
1280 472F              ********************************************************************
1281 472F              * Determine the type of volume in drive
1282 472F              *
1283 472F              * complex for SWIM and FDHD's
1284 472F              *  06 =720 08 =1440 and 00 = unknown
1285 472F              *
1286 472F              ********************************************************************
1287 472F              ID1MEGVOL EQU   *
1288 472F              ; To add support for 720K the IDGCRVol routine must Ident MFM volumes if GCR ID fails
1289 472F A9 03                 LDA   #3                       ;three non timeout retries
1290 4731 8D 37 0F              STA   readret
1291 4734 20 4F 4C     @60      JSR   rdaddr                   ;find an adrsmark
1292 4737 90 0B                 BCC   @70                      ;found a good one no errors
1293 4739 CE 37 0F              DEC   readret
1294 473C F0 04                 BEQ   @err
1295 473E 24 5A                 BIT   temp                     ;if temp is positive
1296 4740 10 F2                 BPL   @60                      ;mark was found but CS/BS error
1297 4742 38           @ERR     SEC   
1298 4743 60                    RTS   
1299 4744 AE 28 0F     @70      LDX   drive
1300 4747 BD 3E 0F              LDA   volsts,x
1301 474A 29 20                 AND   #%00100000               ;preserve only WP status
1302 474C 9D 3E 0F              STA   volsts,x
1303 474F
1304 474F AD 2F 0F              LDA   DblSided                 ;get DS flag from rdaddrs
1305 4752 1D 24 0F              ORA   unitflags,x
1306 4755 9D 24 0F              STA   unitflags,x
1307 4758 30 04                 BMI   @80                      ;its a dbl sided vol type
1308 475A A9 02                 LDA   #AD400K                  ;02 = 400K SS 
1309 475C 80 02                 BRA   @90
1310 475E A9 04        @80      LDA   #AD800K                  ;800K = 04
1311 4760 1D 3E 0F     @90      ORA   VolSts,x
1312 4763 9D 3E 0F              STA   Volsts,x
1313 4766 18                    CLC   
1314 4767 60                    RTS   
1315 4768              ********************************************************************
1316 4768              * 
1317 4768              * MountVol
1318 4768              *
1319 4768              *	Assumes the proper drive has been selected
1320 4768              *
1321 4768              ********************************************************************
1322 4768              MOUNTVOL EQU   *
1323 4768 08                    PHP   
1324 4769 48                    PHA   
1325 476A 8E 28 0F              STX   drive
1326 476D 20 87 4A              JSR   UnkVolx                  ;assume failure: unktyp to volsts
1327 4770              *
1328 4770              * take no prisoners and verify /DIP
1329 4770 A9 02                 LDA   #dipadr
1330 4772 20 7B 49              JSR   ReadBit                  ;
1331 4775 38                    SEC                            ;assume its offline
1332 4776 10 05                 BPL   @20                      ;some people never lie
1333 4778 68                    PLA                            ;discard input A-reg
1334 4779 A9 2F                 LDA   #offline                 ;return OFFLINE error
1335 477B 80 14                 BRA   @errxit
1336 477D
1337 477D              * now have DIP to read and survey for voltype
1338 477D 20 47 49     @20      JSR   MotorON                  ;turn motor on
1339 4780 20 82 48              JSR   Recal                    ;recal to zero for Survey
1340 4783 9C 2B 0F              STZ   side                     ;force 0 for single sided
1341 4786 AE 28 0F              LDX   drive
1342 4789 20 2F 47              JSR   ID1MegVol                ;determine the volume type please
1343 478C 68                    PLA   
1344 478D 90 05                 BCC   @90                      ;voltype identified!
1345 478F A9 27                 LDA   #ioerror                 ;DIP but unreadable is blank media!!
1346 4791 28           @ERRXIT  PLP   
1347 4792 38                    SEC                            ;return an error instead of voltype
1348 4793 60                    RTS   
1349 4794 28           @90      PLP   
1350 4795 60                    RTS   
1351 4796
1352 4796                       TITLE 'Configure the Drive(s)'
1353 4796              *******************************************************************
1354 4796              *                                                                 *
1355 4796              *  Configure                   Look for drives and set those fnd  *
1356 4796              *                                                                 *
1357 4796              *    This clears the drive parameters UnitFlag & UnitID & looks   *
1358 4796              *   at each drive to see if there is a drive there.  If a         *
1359 4796              *   drive is present, it stores a value in the ID byte.  The ID   *
1360 4796              *   byte values are as follows:                                   *
1361 4796              *             ID              Meaning                             *
1362 4796              *          00000000           No drive connected                  *
1363 4796              *          01000000           Drive connected needing ID assign   *
1364 4796              *          1xxxxxxx           Drive connected with ID             *
1365 4796              *   This routine also sets the DrvToAssign byte to the number of  *
1366 4796              *   drives that need IDs.                                         *
1367 4796              *                                                                 *
1368 4796              *   Values set:                                                   *
1369 4796              *     twosided  <-  $80 Double sided default                   *
1370 4796              *     UnitID    <-  $00 No Drive, $40 Drive needing ID         *
1371 4796              *     DrvCnt       <-  number of drives connected                 *
1372 4796              *                                                                 *
1373 4796              *******************************************************************
1374 4796              CONFIGURE EQU   *
1375 4796 A9 40                 LDA   #VSoffline
1376 4798 A2 01                 LDX   #maxdrivs-1
1377 479A 9D 3E 0F     @10      STA   volsts,x                 ;reset volume status to offline
1378 479D 9E 20 0F              STZ   UnitID,x
1379 47A0 9E 24 0F              STZ   UnitFlags,x              ;clear unitmode bits
1380 47A3 CA                    DEX   
1381 47A4 10 F4                 BPL   @10
1382 47A6 9C 39 0F              STZ   DrvToAssign
1383 47A9 9C 1F 0F              STZ   UnitCnt
1384 47AC A9 A0                 LDA   #$A0                     ;constant for BIT
1385 47AE 8D 4D 0F              STA   fakebit
1386 47B1 38                    SEC   
1387 47B2 6E 56 0F              ROR   mideject
1388 47B5              *
1389 47B5              * Do this for maxdrivs drives         
1390 47B5              *
1391 47B5 A2 02                 LDX   #maxdrivs
1392 47B7 80 3F                 BRA   @40
1393 47B9              *
1394 47B9              @20      EQU   *
1395 47B9              *
1396 47B9              * Turn on the right drive
1397 47B9              *
1398 47B9 20 C3 49              JSR   EnblDrivX                ;Drive enabled  
1399 47BC              *
1400 47BC 20 02 48              JSR   IS35drive                ; look for the drive
1401 47BF B0 37                 BCS   @40                      ; nothing present so skip it
1402 47C1              *
1403 47C1              * There's a drive here
1404 47C1 A9 03                 LDA   #ejct_reset
1405 47C3 20 85 49              JSR   WriteBit                 ;clear dsw on Cold or Appl-Ctrl-Reset
1406 47C6              *
1407 47C6              * Now mark the drive stuff
1408 47C6 EE 39 0F              INC   DrvToAssign
1409 47C9 EE 1F 0F              INC   UnitCnt                  ;save a unit count too
1410 47CC A9 40                 LDA   #$40
1411 47CE 9D 20 0F              STA   Unitid,x
1412 47D1              *
1413 47D1 A9 05                 LDA   #FDHDAdr                 ;see if its an Apple FDHD
1414 47D3 20 7B 49              JSR   ReadBit
1415 47D6 10 08                 BPL   @30                      ;nope
1416 47D8 A9 20                 LDA   #UFfdhd
1417 47DA 1D 24 0F              ORA   UnitFlags,x
1418 47DD 9D 24 0F              STA   UnitFlags,x              ;set the driv type bit
1419 47E0              *
1420 47E0              @30      EQU   *
1421 47E0 A5 45                 LDA   cmdcode
1422 47E2 29 BF                 AND   #%10111111
1423 47E4 C9 49                 CMP   #initcmd                 ;ROM 03 BUG - should be cmddefid - fixed 5/29/91 JOA
1424 47E6 D0 04                 BNE   @35
1425 47E8 24 48                 BIT   cmdscode                 ; allows special INIT command to skip Sens & MountVol!!
1426 47EA 70 0C                 BVS   @40                      ;don't do this now
1427 47EC 20 D2 49     @35      JSR   SensX                    ;set volsts per sense bits
1428 47EF 18                    CLC                            ; MountVol preserves carry
1429 47F0 20 68 47              JSR   MountVol                 ;identify volume type if possible
1430 47F3 90 03                 BCC   @40                      ;vol type now known
1431 47F5              *
1432 47F5              * No address field was found.  This could be because:
1433 47F5              *  1)  A dummy disk is in place
1434 47F5              *  2)  The cassette compartment is down but no disk is in place
1435 47F5              *  3)  There is a blank piece of media or plastic shipdisk
1436 47F5              *   -> Eject the media in all cases.
1437 47F5              *
1438 47F5 20 AE 48              JSR   eject
1439 47F8              *
1440 47F8              @40      EQU   *
1441 47F8 CA                    DEX                            ;Maybe a next drive
1442 47F9 8E 28 0F              STX   drive
1443 47FC 10 BB                 BPL   @20                      ;Maybe another drive
1444 47FE              *
1445 47FE 2C E8 C0              BIT   DeSelect
1446 4801 60                    RTS   
1447 4802              **********************************************************************
1448 4802              *
1449 4802              * IS35drive    This routine will check a Dsony drive present on a
1450 4802              *              previously specified enable line.  The routine tries
1451 4802              *              to set the direction on the drive and then check if the
1452 4802              *              direction has changed.  The direction gets set in, out
1453 4802              *              and in again.  If it passes all three checks then we
1454 4802              *              assume that a drive is present.  On exit carry will be
1455 4802              *              cleared if a drive is found and set otherwise.
1456 4802              *
1457 4802              *     Import: The specific enable set prior to calling the routine
1458 4802              *     Export: C = 0 if drive found
1459 4802              *             C = 1 if drive not found
1460 4802              *
1461 4802              ******************************************************************
1462 4802 A9 00        IS35DRIVE LDA   #dirinadr               ; point the drive head in
1463 4804 20 85 49              JSR   writebit                 ;
1464 4807 20 7B 49              JSR   readbit                  ; get the status
1465 480A 30 15                 BMI   @10                      ; can not see it
1466 480C A9 01                 LDA   #diroutadr               ; point towards edge of disk
1467 480E 20 85 49              JSR   writebit                 ;
1468 4811 20 7B 49              JSR   readbit                  ; get the status
1469 4814 10 0B                 BPL   @10                      ; something wrong
1470 4816 A9 00                 LDA   #dirinadr                ; point in again
1471 4818 20 85 49              JSR   writebit                 ; set direction in
1472 481B 20 7B 49              JSR   readbit                  ;
1473 481E 18                    CLC                            ; assume drive found
1474 481F 10 01                 BPL   @20                      ; and go away
1475 4821 38           @10      SEC                            ; no drive
1476 4822 60           @20      RTS   
1477 4823                       TITLE 'Seek Routine'
1478 4823              **************************************************
1479 4823              *                                                *
1480 4823              *  seek                     Seek to a cylinder   *
1481 4823              *                     Assume curcyl is correct   *
1482 4823              *                                                *
1483 4823              *   Input:    cyl <- cylinder to seek to         *
1484 4823              *             drive <- drive on which to seek    *
1485 4823              *             curcyl <- head rests here          *
1486 4823              *   Output:   C <- set if seek error occurred    *
1487 4823              *             curnsect <- # sectors this cyl     *
1488 4823              *   Uses:     recal, sendsteps, WriteBit         *
1489 4823              *   Regs:     A <- error2 (if carry set)         *
1490 4823              *   Destroys: X, Y                               *
1491 4823              *                                                *
1492 4823              **************************************************
1493 4823                                                      ; SEG	fake_it	;
1494 4823              SEEKA    EQU   *
1495 4823 8D 29 0F              STA   cyl
1496 4826                                                      ; SEG	code	;
1497 4826              SEEK     EQU   *
1498 4826                                                      ; SEG	fake_it	;
1499 4826 5C 87 0F E1           JMP   SeekHook
1500 482A              *
1501 482A              * If drive is offline (cyl unknown), do a recal
1502 482A AE 28 0F              LDX   drive
1503 482D 3C 3A 0F              BIT   curcyl,x                 ;Set N to online
1504 4830 10 05                 BPL   @05                      ;If cyl known, skip recal
1505 4832 20 82 48              JSR   recal
1506 4835 B0 2F                 BCS   seekerr
1507 4837              @05      EQU   *
1508 4837              *
1509 4837              * Determine # of steps to take, and direction
1510 4837 38                    SEC   
1511 4838 AE 28 0F              LDX   drive
1512 483B BD 3A 0F              LDA   curcyl,x
1513 483E ED 29 0F              SBC   cyl                      ;Calculate delta 
1514 4841 F0 12                 BEQ   seekdone                 ;If on track, skip down
1515 4843              *
1516 4843              * At this point, C clear means inward seek, ow out
1517 4843 A0 01                 LDY   #diroutadr               ;Assume outward seek 
1518 4845 B0 06                 BCS   @10                      ;Branch on outward seek
1519 4847              *
1520 4847 A0 00                 LDY   #dirinadr                ;Setnasrt value for inward seek
1521 4849 49 FF                 EOR   #$FF                     ;Gotta convert the negative delta
1522 484B 69 01                 ADC   #1                       ;Carry was already clear 
1523 484D              *
1524 484D              @10      EQU   *
1525 484D AA                    TAX                            ;Move delta to X reg
1526 484E 98                    TYA                            ;Set up to set the direction
1527 484F 20 85 49              JSR   WriteBit
1528 4852              *
1529 4852              * Now do the stepping; delta in X
1530 4852 20 6F 48              JSR   sendsteps                ;Send the step pulses 
1531 4855              *
1532 4855              SEEKDONE EQU   *
1533 4855              * 
1534 4855              * Update the current cylinder byte and exit error free 
1535 4855 AE 28 0F              LDX   drive
1536 4858 AD 29 0F              LDA   cyl
1537 485B 9D 3A 0F              STA   curcyl,x
1538 485E              *
1539 485E 20 10 4B              JSR   cylsect                  ;Map to sectors this cylinder
1540 4861 8D 2C 0F              STA   curnsect                 ;Update # sectors this cyl
1541 4864              *
1542 4864 18                    CLC                            ;Return Good!
1543 4865 60                    RTS   
1544 4866              *
1545 4866              * Flip the seek error bit on (carry set previously) 
1546 4866              SEEKERR  EQU   *
1547 4866 A9 02                 LDA   #seekerror
1548 4868 0D 44 0F              ORA   error2
1549 486B 8D 44 0F              STA   error2
1550 486E              SKERR    EQU   *
1551 486E 60                    RTS   
1552 486F                       TITLE 'Track Stepping Routine'
1553 486F              **************************************************
1554 486F              *                                                *
1555 486F              *  sendsteps           Steps a number of tracks  * 
1556 486F              *                        assume IWMDIR to drive  *
1557 486F              *                                   and dir set  * 
1558 486F              *                                                *
1559 486F              *   Input:    X <- number of tracks to step      *
1560 486F              *   Destroys: A, Y                               *
1561 486F              *             X cleared                          *
1562 486F              *                                                *
1563 486F              *  (Delays after stepping until /READY is valid) *
1564 486F              *                                                *
1565 486F              **************************************************
1566 486F              SENDSTEPS EQU   *
1567 486F              *
1568 486F              * Take a step
1569 486F              *
1570 486F A9 04                 LDA   #step0adr
1571 4871 20 85 49              JSR   WriteBit
1572 4874              *
1573 4874              * Wait for handshake from drive
1574 4874              *
1575 4874 20 7E 49     SS1      JSR   IWMsense
1576 4877 10 FB                 BPL   ss1
1577 4879              *
1578 4879              * See if more steps to do
1579 4879              *
1580 4879 CA                    DEX   
1581 487A D0 F3                 BNE   sendsteps
1582 487C              *
1583 487C              * The current Sony /READY is not valid for 150 microseconds after a
1584 487C              *  step pulse.
1585 487C              *
1586 487C A2 4F                 LDX   #$4F                     ; constant for 150 usec delay
1587 487E CA           WAIT150M DEX   
1588 487F D0 FD                 BNE   wait150m
1589 4881 60                    RTS   
1590 4882                       TITLE 'Recalibrate'
1591 4882              **************************************************
1592 4882              *                                                *
1593 4882              *  recal                       Seek to track 0   *
1594 4882              *                                                *
1595 4882              *   Input:    drive <- current drive             *
1596 4882              *   Output:   curcyl <- 0                        *
1597 4882              *             C <- clr:okay, ow step/sensor err  *
1598 4882              *             X <- drive                         *
1599 4882              *   Destroys: A, X, Y                            *
1600 4882              *                                                *
1601 4882              **************************************************
1602 4882              RECAL    EQU   *
1603 4882              *
1604 4882              * Set the step direction to out
1605 4882              *
1606 4882 A9 01                 LDA   #diroutadr
1607 4884 20 85 49              JSR   WriteBit
1608 4887              *
1609 4887 A9 0A                 LDA   #tk0adr
1610 4889 20 7B 49              JSR   ReadBit                  ;is is already at trk0?
1611 488C 18                    CLC   
1612 488D 10 18                 BPL   @30                      ;yes. so alldone
1613 488F              *
1614 488F              * Send a whole bunch of step pulses
1615 488F              *
1616 488F A2 50                 LDX   #recaltrks
1617 4891 20 6F 48              JSR   sendsteps
1618 4894              *
1619 4894              * Now wait for /TK0 with timeout
1620 4894              *
1621 4894 A2 55                 LDX   #recaltrks+5             ;head settling = 5 trk seeks
1622 4896 A9 07        @10      LDA   #tk0wait                 ;Gonna wait a few ms
1623 4898 20 62 4A              JSR   waitms
1624 489B              *
1625 489B A9 0A                 LDA   #tk0adr
1626 489D 20 7B 49              JSR   ReadBit
1627 48A0 18                    CLC   
1628 48A1 10 04                 BPL   @30                      ;=> Saw track 0 
1629 48A3              *
1630 48A3 CA                    DEX   
1631 48A4 D0 F0                 BNE   @10
1632 48A6              *
1633 48A6              * Never saw /TK0
1634 48A6              *
1635 48A6              @20      EQU   *
1636 48A6 38                    SEC   
1637 48A7              @30      EQU   *
1638 48A7 AE 28 0F              LDX   drive
1639 48AA 9E 3A 0F              STZ   curcyl,x
1640 48AD 60                    RTS   
1641 48AE                       TITLE 'Eject the Diskette'
1642 48AE              **************************************************
1643 48AE              *                                                *
1644 48AE              *  eject                   Ejects the diskette   *
1645 48AE              *                                                *
1646 48AE              *   Output:   C <- set if eject fails            *
1647 48AE              *   Destroys: A,X,Y                              *
1648 48AE              *                                                *
1649 48AE              **************************************************
1650 48AE              EJECT    EQU   *
1651 48AE              *
1652 48AE              * Make sure there is a disk in there
1653 48AE A9 02                 LDA   #dipadr
1654 48B0 20 7B 49              JSR   ReadBit
1655 48B3 30 68                 BMI   @90                      ;no. so insure it unmounted!
1656 48B5              *
1657 48B5 AE 28 0F              LDX   drive
1658 48B8 BD 3A 0F              LDA   curcyl,x                 ;save current posn
1659 48BB 10 02                 BPL   @01
1660 48BD A9 00                 LDA   #00                      ;if cyl unknown Seek does a Recal
1661 48BF 48           @01      PHA                            ;save it for later
1662 48C0 A9 4F                 LDA   #79                      ;pull head inward  BUT don't verify
1663 48C2 20 23 48              JSR   SeekA                    ;arrival since RdAdrs is the only means
1664 48C5              *
1665 48C5              * Must first turn off the motor
1666 48C5 A9 09                 LDA   #mtroffadr
1667 48C7 20 85 49              JSR   WriteBit
1668 48CA              *
1669 48CA              * And you gotta wait minimum of 200 milliseconds (Kamoto says)
1670 48CA 68                    PLA   
1671 48CB 8D 29 0F              STA   cyl
1672 48CE A9 50                 LDA   #80
1673 48D0 ED 29 0F              SBC   cyl                      ;calc length of seek  
1674 48D3 C9 22                 CMP   #34                      ;33 is to few
1675 48D5 B0 02                 BCS   @03
1676 48D7 A9 22                 LDA   #34                      ;at minimum wait is 200 ms
1677 48D9 8D 29 0F     @03      STA   cyl                      ;eg IF A = 80
1678 48DC 0A                    ASL   a                        ; THEN A =160 
1679 48DD 18                    CLC                            ; PLUS     80 = 240 * 2 = 480 Ms
1680 48DE 6D 29 0F              ADC   cyl                      ; EQUALS  6ms / 80trks = 480 ms
1681 48E1 20 5D 4A              JSR   Wait2Ms                  ;wait 6ms / trk (min 200)
1682 48E4              *
1683 48E4 A9 03                 LDA   #EjectRetries            ;# of attempts to eject
1684 48E6 8D 35 0F              STA   seekret
1685 48E9              *
1686 48E9              * Now set a flag that says we're in the middle of an eject this drive
1687 48E9              *  This is important in case we're reset while ejecting
1688 48E9 AE 28 0F              LDX   drive
1689 48EC 8E 56 0F              STX   MidEject
1690 48EF              @10      EQU   *
1691 48EF A9 0D                 LDA   #eject1adr
1692 48F1 20 85 49              JSR   WriteBit
1693 48F4              ;
1694 48F4 A9 C3                 LDA   #EjectTimeOut
1695 48F6 8D 37 0F              STA   readret                  ;This many groups of 10 ms timeout
1696 48F9              @20      EQU   *
1697 48F9 A9 0A                 LDA   #10
1698 48FB 20 62 4A              JSR   waitms                   ;Wait a while
1699 48FE              *
1700 48FE              * Now see if the cassette actually out 
1701 48FE              *
1702 48FE A9 02                 LDA   #dipadr
1703 4900 20 7B 49              JSR   ReadBit
1704 4903 30 0F                 BMI   @40
1705 4905 CE 37 0F              DEC   readret
1706 4908 D0 EF                 BNE   @20                      ;Maybe next time
1707 490A              *
1708 490A              * Failed an attempt.  Maybe send the command again.
1709 490A              *
1710 490A CE 35 0F              DEC   seekret
1711 490D D0 E0                 BNE   @10
1712 490F              *
1713 490F              * Disk was NOT ejected.  Set carry and return.
1714 490F A9 27                 LDA   #ioerror                 ;Set up error byte
1715 4911 82 5B F3              BRL   set_err                  ; mark an error
1716 4914              *
1717 4914              * The disk was ejected. UnMount volume  (clear state vars)
1718 4914              @40      EQU   *
1719 4914              *
1720 4914 A9 01                 LDA   #1
1721 4916 20 62 4A              JSR   waitms
1722 4919 38                    SEC   
1723 491A 6E 56 0F              ROR   MidEject                 ;Clear the mideject flag
1724 491D              *
1725 491D AE 28 0F     @90      LDX   drive
1726 4920 20 7F 4A              JSR   OfflineX                 ;clear volsts and set offline (X)
1727 4923 18                    CLC   
1728 4924 60                    RTS   
1729 4925              *
1730 4925              *****************************************************************
1731 4925              *                                                               *
1732 4925              *  WaitRdyTO   Waits for /READY for 1.5 seconds                 * 
1733 4925              *                                                               *
1734 4925              *****************************************************************
1735 4925              WAITRDYTO EQU   *
1736 4925              *
1737 4925              * Set up to read the /READY line
1738 4925              *
1739 4925 A9 0B                 LDA   #readyadr
1740 4927 20 7B 49              JSR   ReadBit                  ;Set the control lines
1741 492A 2C EE C0              BIT   l7clr
1742 492D 30 02                 BMI   @10                      ;its not ready on 1st try
1743 492F 18           @RDY     CLC   
1744 4930 60                    RTS   
1745 4931              *
1746 4931              * Now Poll for /Ready for 1.5 seconds max
1747 4931 A2 05        @10      LDX   #>1500
1748 4933 A0 DC                 LDY   #<1500
1749 4935 A9 01        @20      LDA   #01
1750 4937 20 62 4A              JSR   waitms                   ;waste about 1 ms
1751 493A 2C EE C0              BIT   l7clr                    ;and test again
1752 493D 10 F0                 BPL   @rdy
1753 493F 88                    DEY   
1754 4940 D0 F3                 BNE   @20
1755 4942 CA                    DEX   
1756 4943 D0 F0                 BNE   @20
1757 4945 38                    SEC   
1758 4946 60                    RTS   
1759 4947                       EJECT 
1760 4947              ***********************************************************
1761 4947              *
1762 4947              * MotorOn
1763 4947              *
1764 4947              ***********************************************************
1765 4947              MOTORON  EQU   *
1766 4947              *
1767 4947              * First check if the motor is on already
1768 4947              *
1769 4947 A9 08                 LDA   #mtronadr
1770 4949 20 7B 49              JSR   ReadBit
1771 494C 10 1C                 BPL   @90
1772 494E
1773 494E 20 88 49              JSR   PULSELSTB
1774 4951              *
1775 4951              * Have to wait either 50 or 500 milliseconds before proceeding
1776 4951              *
1777 4951 AE 28 0F              LDX   drive
1778 4954 A9 10                 LDA   #UFchukwait              ;
1779 4956 3C 24 0F              BIT   UnitFlags,x
1780 4959 D0 0A                 BNE   @10
1781 495B 1D 24 0F              ORA   UnitFlags,x
1782 495E 9D 24 0F              STA   Unitflags,x              ;set the chuckwait done bit
1783 4961 A9 FA                 LDA   #InMupWait               ;500 
1784 4963 80 02                 BRA   @20
1785 4965 A9 32        @10      LDA   #StdMupWait              ;100
1786 4967 20 5D 4A     @20      JSR   wait2ms                  ;Wait some time
1787 496A 60           @90      RTS   
1788 496B                       TITLE 'Low Level Drive Control Routines'
1789 496B              ***************************************************
1790 496B              *
1791 496B              * SetHead
1792 496B              ***************************************************
1793 496B              SETHEAD  EQU   *
1794 496B AD 31 C0              LDA   diskreg                  ; get disk/hdsel register
1795 496E 29 7F                 AND   #$7F                     ; mask off head select bit
1796 4970 2C 2B 0F              BIT   side                     ; check which side
1797 4973 10 02                 BPL   shead0                   ; set head 0
1798 4975 09 80                 ORA   #$80                     ; else set head 1
1799 4977 8D 31 C0     SHEAD0   STA   diskreg                  ; set it
1800 497A 60                    RTS   
1801 497B              *
1802 497B              **************************************************
1803 497B              *                                                *
1804 497B              *  ReadBit                Control routines for   *
1805 497B              *  WriteBit       reading/writing signals from   *
1806 497B              *                               the SONY drive   *
1807 497B              *                                                *
1808 497B              *                                                *
1809 497B              *   Input:    A <-  X X X X CA1 CA0 SEL CA2      *
1810 497B              *   Regs:     A cleared (ReadBit: IWM status)    *
1811 497B              *             X preserved                        *
1812 497B              *             Y destroyed                        *
1813 497B              *   Time:     72 microsecs (inc JSR)             *
1814 497B              *                                                *
1815 497B              **************************************************
1816 497B              READBIT  EQU   *
1817 497B              *
1818 497B              * Set up the control lines
1819 497B              *
1820 497B 20 8F 49              JSR   sdclines
1821 497E              *
1822 497E              * Now read the sense line from the IWM into the N flag
1823 497E              *
1824 497E 2C ED C0     IWMSENSE BIT   l6set                    ;Set L6 
1825 4981 AD EE C0              LDA   l7clr                    ;Read the status
1826 4984 60                    RTS   
1827 4985              *
1828 4985              ********************************************************
1829 4985              *   WriteBit
1830 4985              *
1831 4985              **********************************************************
1832 4985              WRITEBIT EQU   *
1833 4985              *
1834 4985              * Set up the lines, then 'LSTRB' Acc's lsb over
1835 4985              *
1836 4985 20 8F 49              JSR   sdclines
1837 4988              *
1838 4988 2C E7 C0     PULSELSTB BIT   lstrbset                ;Raise LSTRB
1839 498B 2C E6 C0              BIT   lstrbclr                 ;Lower it after 2 micros (twice spec)
1840 498E 60                    RTS   
1841 498F                       EJECT 
1842 498F              ***********************************************************
1843 498F              *
1844 498F              * SDCLINES
1845 498F              ***********************************************************
1846 498F              SDCLINES EQU   *
1847 498F              *
1848 498F              * Must set CA0, CA1 before changing HDSEL 1->0
1849 498F              *
1850 498F 2C E0 C0              BIT   ca0clr
1851 4992 2C E3 C0              BIT   ca1set
1852 4995 2C E6 C0              BIT   lstrbclr                 ;
1853 4998              *
1854 4998              * Set CA2 per Acc lsb
1855 4998              *
1856 4998 2C E4 C0              BIT   ca2clr                   ;Assume lsb clear
1857 499B 4A                    LSR   a                        ;lsb -> C; Acc has 0XXXX CA1 CA0 SEL
1858 499C 90 03                 BCC   sdcla                    ;=> We were right
1859 499E 2C E5 C0              BIT   ca2set                   ;We were wrong, set CA2
1860 49A1              *
1861 49A1              * Deal with SEL setting
1862 49A1              *
1863 49A1              SDCLA    EQU   *
1864 49A1 4A                    LSR   a                        ;SEL -> C; Acc has 00XXXX CA1 CA0
1865 49A2 48                    PHA                            ;Hold that thought
1866 49A3 AD 31 C0              LDA   diskreg                  ;Assume SEL will be 0
1867 49A6 29 7F                 AND   #$7F                     ; => I'm just psychic
1868 49A8 90 02                 BCC   sdclb                    ; Luckily HDSEL is lsb
1869 49AA 09 80                 ORA   #$80                     ; set Hdsel to a one
1870 49AC 8D 31 C0     SDCLB    STA   diskreg                  ; Finally set SEL correctly
1871 49AF 68                    PLA                            ;Get CA0 & CA1 back
1872 49B0              *
1873 49B0              * Now for CA0, CA1. CA0 is low, CA1 is high,
1874 49B0              *  clear them if we were asked to.
1875 49B0              *
1876 49B0 4A                    LSR   a                        ;C has CA0
1877 49B1 90 03                 BCC   sdclc                    ;If 0, nothing to be done
1878 49B3 2C E1 C0              BIT   ca0set                   ;Okay, set it
1879 49B6              *
1880 49B6 4A           SDCLC    LSR   a                        ;Get the CA1
1881 49B7 B0 03                 BCS   sdcld
1882 49B9 2C E2 C0              BIT   ca1clr                   ;Clear it
1883 49BC              *
1884 49BC 60           SDCLD    RTS   
1885 49BD              *******************************************************************
1886 49BD              *                                                                 *
1887 49BD              *  EnblUnitX      Enable unit given in X-reg if it exists         *
1888 49BD              *                                                                 *
1889 49BD              *    Input   X-reg : 0/1 - Specify the unit to enable             *
1890 49BD              *    Output  A : destroyed                                        *
1891 49BD              *         X &Y : preserved                                        *
1892 49BD              *            C : clr if drive enabled, set if drive non-existant  *
1893 49BD              *                                                                 *
1894 49BD              *******************************************************************
1895 49BD              * Check if this drive is connected
1896 49BD 38           ENBLUNITX SEC   
1897 49BE BD 20 0F              LDA   UnitId,x                 ;does unit exits?
1898 49C1 F0 07                 BEQ   enexit                   ;yes
1899 49C3              ***************
1900 49C3 3C EA C0     ENBLDRIVX BIT   enable1,x               ; enable proper drive ;
1901 49C6 2C E9 C0              BIT   Select                   ; activate the enable line
1902 49C9 18                    CLC   
1903 49CA 60           ENEXIT   RTS   
1904 49CB              ****************
1905 49CB              DRIVESOFF EQU   *
1906 49CB 2C E8 C0              BIT   DeSelect                 ; deactivate the drive enable
1907 49CE 60                    RTS   
1908 49CF                       EJECT 
1909 49CF              ***********************************************************
1910 49CF              * EnblnSens
1911 49CF              *
1912 49CF              *
1913 49CF              *
1914 49CF              *
1915 49CF              *
1916 49CF              ***********************************************************
1917 49CF              ENBLNSENS EQU   *
1918 49CF 20 BD 49              JSR   EnblUnitX
1919 49D2 BD 3E 0F     SENSX    LDA   volsts,x
1920 49D5 8D 4C 0F              STA   priorsts                 ;save for history compares
1921 49D8 29 1F                 AND   #$1F                     ;preserve voltype index
1922 49DA 09 20                 ORA   #VSwrprot                ;preset b5 so EOR resets
1923 49DC 9D 3E 0F              STA   volsts,x
1924 49DF 9B                    TXY   
1925 49E0 A2 03                 LDX   #3
1926 49E2 BF FE 49 FF  @10      LDA   >sensbit-1,x
1927 49E6 20 7B 49              JSR   readbit
1928 49E9 10 0A                 BPL   @20
1929 49EB BF 01 4A FF           LDA   >statbit-1,x
1930 49EF 59 3E 0F              EOR   volsts,y
1931 49F2 99 3E 0F              STA   volsts,y
1932 49F5 CA           @20      DEX   
1933 49F6 D0 EA                 BNE   @10
1934 49F8 BB                    TYX   
1935 49F9 A9 20                 LDA   #VSwrprot
1936 49FB 3C 3E 0F              BIT   volsts,x
1937 49FE 60                    RTS   
1938 49FF              *
1939 49FF                                                      ; SEG	code
1940 49FF 06 02 0C     SENSBIT  DC B:WPROTADR,DIPADR,EJCTADR
1941 4A02 20 40 80     STATBIT  DC B:VSWRPROT,VSOFFLINE,VSEJCTED
1942 4A05                                                      ; SEG	fake_it
1943 4A05              ************************************************************
1944 4A05              * SensnChk
1945 4A05              *
1946 4A05              *   Sense the drive status and return priority encoded errors
1947 4A05              * as follows:
1948 4A05              *
1949 4A05              * Enable drive and save 3 Sense bits in volsts
1950 4A05              * IF media Offline
1951 4A05              * THEN 'Offline' the volsts :
1952 4A05              *    : If dsw Then clear dswlatch : EC = 00
1953 4A05              *                  if ext.cmd then EC = Disk Switched ($2E)
1954 4A05              *                  else EC = Offline ($2F) 
1955 4A05              *    : Err = 1 : rtn n,v bits  : exit
1956 4A05              * ELSE Disk-in-Place   
1957 4A05              *   If dsw Then 'UnMount' volsts : clear dswlatch 
1958 4A05              *        : if ext.cmd then EC = $2E : Err = 1: rtn n,v bits : exit
1959 4A05              * IF Mode = Write THEN If WritProt Then EC = $2B : Err = 1 : exit
1960 4A05              * IF voltype = unknown THEN mount =1 
1961 4A05              * RETURN
1962 4A05              *
1963 4A05              *  INPUT :   R/W Mode = Carry   Set = Write   Clr = Read
1964 4A05              *
1965 4A05              * OUTPUT :               Err EC Mnt /DIP
1966 4A05              *   case description      C   A  N  V (Carry, A-reg, N-flag, V-flag)
1967 4A05              * -------------------------------------------------------------------
1968 4A05              * No Media    & DSW set   1  $2E 1  1 Disk Switched (extended cmd)
1969 4A05              * No Media    & DSW set   1  $2F 1  1 Offline error (std cmd)
1970 4A05              * No Media    & DSW clr   1  $2F 0  1 Offline after dsw cleared
1971 4A05              * DiskInPlac & DSW set    1  $2E 1  0 Disk Switched (extended cmd)
1972 4A05              * DiskInPlac & Wp & DSW   1  $2B 1  0 NoWrite (std cmd & write mode)
1973 4A05              * DiskInPlac & Wp & noDSW 1  $2B 0  0 NoWrite (std cmd & write mode)
1974 4A05              * DiskInPlac & DSW set    0  $00 1  0 MountVol   (std cmd)
1975 4A05              * DiskInPlac & Dsw clr    0  $80 1  0 MountVol unknown voltype 
1976 4A05              * DiskInPlac & Dsw clr    0  $00 0  0 Known online volume (at last)
1977 4A05              * 
1978 4A05              ************************************************************
1979 4A05              SENSNCHK EQU   *
1980 4A05 08                    PHP                            ;save R/W mode
1981 4A06 AE 28 0F              LDX   drive                    ;enable and check drive
1982 4A09 20 CF 49              JSR   EnblnSens                ;get the drive status bits
1983 4A0C 50 11                 BVC   @DIP                     ;Drive carrier down (and thus media?)
1984 4A0E              *
1985 4A0E              * Volume is OFFLINE
1986 4A0E 08                    PHP                            ;save n flag
1987 4A0F 20 7F 4A              JSR   OfflineX                 ;clear volume type and set offline
1988 4A12 28                    PLP   
1989 4A13 10 05                 BPL   @05                      ;offline and not DSW
1990 4A15 20 4C 4A              JSR   ClearDSW                 ;clear drive latch and rtn dswerr 
1991 4A18 B0 02                 BCS   @10                      ;have dsw error to return
1992 4A1A A9 2F        @05      LDA   #offline                 ;if not dsw then Offline error
1993 4A1C 28           @10      PLP                            ;discard R/W mode 
1994 4A1D 80 16                 BRA   @chkerr                  ;exit with WP error
1995 4A1F              *
1996 4A1F              * here IF ONLINE true
1997 4A1F 10 08        @DIP     BPL   @WPtest                  ;DIP but not DSW!
1998 4A21              * OK do DIP true and eject true also
1999 4A21 20 87 4A              JSR   UnkVolX                  ;set volsts to online but unknown
2000 4A24 20 4C 4A              JSR   ClearDSW                 ;clear drive latch 
2001 4A27 B0 F3                 BCS   @10                      ;its dswerror!
2002 4A29              *
2003 4A29              * Now do the Write Protect check
2004 4A29 28           @WPTEST  PLP                            ;carry set say return WP error
2005 4A2A 90 0C                 BCC   @volchk                  ;read mode so don't check WP
2006 4A2C A9 20                 LDA   #VSwrProt
2007 4A2E 3D 3E 0F              AND   volsts,x                 ;NE if Wprot and Write
2008 4A31 F0 05                 BEQ   @volchk                  ;no WP error
2009 4A33 A9 2B                 LDA   #WPerror
2010 4A35 38           @CHKERR  SEC   
2011 4A36 80 10                 BRA   @exit
2012 4A38              *
2013 4A38              * Now have Online, no dswerr, no WP err
2014 4A38 BD 3E 0F     @VOLCHK  LDA   volsts,x                 ;volume type is low 5 bits 
2015 4A3B 29 1F                 AND   #$1F                     ;drop sense bits
2016 4A3D 18                    CLC                            ;return no error!
2017 4A3E D0 06                 BNE   @noerr                   ;yeah. a normal access to known voltype
2018 4A40 3C 3E 0F              BIT   volsts,x
2019 4A43 A9 80                 LDA   #$80                     ;force n=1 preserve v and c=0
2020 4A45 60                    RTS   
2021 4A46 A9 00        @NOERR   LDA   #00
2022 4A48 3C 3E 0F     @EXIT    BIT   volsts,x
2023 4A4B 60                    RTS   
2024 4A4C              *******************************************
2025 4A4C              * Clear DSW etc
2026 4A4C              *
2027 4A4C              *  INPUT : X = drive number (0,1)
2028 4A4C              *
2029 4A4C              *  OUTPUT: A = 00 or $2E 
2030 4A4C              *          A = dswerror if extended cmd 
2031 4A4C              *          C = 1 if err
2032 4A4C              *          C = 0 if no error
2033 4A4C              *
2034 4A4C              *******************************************
2035 4A4C              CLEARDSW EQU   *
2036 4A4C A9 03                 LDA   #ejct_reset
2037 4A4E 20 85 49              JSR   WriteBit                 ;clear the drive latch
2038 4A51 A9 00                 LDA   #00
2039 4A53 18                    CLC   
2040 4A54 2C 1E 0F              BIT   ext_flag
2041 4A57 50 03                 BVC   @10
2042 4A59 A9 2E                 LDA   #dswerror                ;replace callers with mine
2043 4A5B 38                    SEC   
2044 4A5C 60           @10      RTS   
2045 4A5D                       TITLE 'Time Delay Subroutines'
2046 4A5D              **************************************************
2047 4A5D              *                                                *
2048 4A5D              *  waitms        Wait the specified # millisecs  * 
2049 4A5D              *                         assuming a 2MHZ clock  *
2050 4A5D              *                   (accurate to roughly +0.7%)  * 
2051 4A5D              *                                                *
2052 4A5D              *  If code straddles pages, it is less accurate  *
2053 4A5D              *                                                *
2054 4A5D              *   Input:    A <- milliseconds of delay         *
2055 4A5D              *   Destroys: A; temp and temp2 cleared          *
2056 4A5D              *   Prserves: X, Y                               *
2057 4A5D              *                                                *
2058 4A5D              **************************************************
2059 4A5D              WAIT2MS  EQU   *
2060 4A5D 48                    PHA   
2061 4A5E 20 62 4A              JSR   waitms
2062 4A61 68                    PLA   
2063 4A62              *****************
2064 4A62              WAITMS   EQU   *                        ;Time= 0.0005*(A*2013+9) 
2065 4A62              *                              ;    = Acc * 1.007 millisecs
2066 4A62 85 5B                 STA   temp2                    ;(3) 
2067 4A64 AD 36 C0              LDA   cyareg                   ; slow down
2068 4A67 48                    PHA                            ; save old settings
2069 4A68 29 7F                 AND   #$7F                     ;
2070 4A6A 8D 36 C0              STA   cyareg                   ;
2071 4A6D              *
2072 4A6D A9 64        WAITB    LDA   #tconstant               ;(2) waitb is >1022 slow cycles 
2073 4A6F 85 5A                 STA   temp                     ;(3) 
2074 4A71              *
2075 4A71 C6 5A        WAITA    DEC   temp                     ;(5) waita is 10 cycles
2076 4A73 EA                    NOP                            ;(2) 
2077 4A74 D0 FB                 BNE   waita                    ;(3,2) 
2078 4A76              *
2079 4A76 C6 5B                 DEC   temp2                    ;(5) 
2080 4A78 D0 F3                 BNE   waitb                    ;(3,2) 
2081 4A7A              *
2082 4A7A 68                    PLA                            ;(4) restore cya register
2083 4A7B 8D 36 C0              STA   cyareg                   ;(4)
2084 4A7E 60                    RTS                            ;(2) = 25+20= 45
2085 4A7F
2086 4A7F              ************************************
2087 4A7F              * Offline
2088 4A7F              *
2089 4A7F              * Reset all variables for media  Offline
2090 4A7F              *
2091 4A7F              ******************************************
2092 4A7F              OFFLINEX EQU   *
2093 4A7F A9 40                 LDA   #%01000000               ;set offline bit
2094 4A81 1D 3E 0F              ORA   Volsts,x
2095 4A84 9D 3E 0F              STA   Volsts,x
2096 4A87 BD 24 0F     UNKVOLX  LDA   UnitFlags,x
2097 4A8A 29 6F                 AND   #%01101111               ;enable chukwait next DIP access
2098 4A8C 9D 24 0F              STA   UnitFlags,x
2099 4A8F A9 FF                 LDA   #$FF
2100 4A91 9D 3A 0F              STA   curcyl,x                 ;reset to unknown track ($FF)
2101 4A94 BD 3E 0F              LDA   volsts,x
2102 4A97 29 E0                 AND   #%11100000               ;scratch voltype
2103 4A99 9D 3E 0F              STA   Volsts,x                 ;volume status to unknown
2104 4A9C 60                    RTS   
2105 4A9D                       TITLE 'Block Mapping Routine'
2106 4A9D              **************************************************
2107 4A9D              *                                                *
2108 4A9D              *  BlkMap           Map the block number to      *
2109 4A9D              *                       track, sector, side      *
2110 4A9D              *                                                *
2111 4A9D              *   Input:    CmdBlockl,h <- block to convert    *
2112 4A9D              *             drive <- current device            *
2113 4A9D              *             twosided <- for the current dev    *
2114 4A9D              *   Output:   cyl, sector, side                  *
2115 4A9D              *   Uses:     TrackSect                          *
2116 4A9D              *   Regs:     A <- sector                        *
2117 4A9D              *             X <- drive                         *
2118 4A9D              *   Destroys: Y, temp                            *
2119 4A9D              *   Max time: 316 microsec  (2MHZ)               *
2120 4A9D              *                                                *
2121 4A9D              **************************************************
2122 4A9D              BLKMAP   EQU   *
2123 4A9D AE 28 0F              LDX   drive
2124 4AA0 BD 3E 0F              LDA   volsts,x
2125 4AA3 29 1F                 AND   #$1F                     	;extract voltype
2126 4AA5 A8                    TAY   
2127 4AA6 BD 24 0F              LDA   UnitFlags,x
2128 4AA9 C0 02                 CPY   #02                      	;single sided?
2129 4AAB D0 04                 BNE   @05
2130 4AAD 29 7F                 AND   #-1-UFdblsided
2131 4AAF 80 02                 BRA   @06
2132 4AB1 09 80        @05      ORA   #UFdblsided              ;set flag for Dblsided vol type
2133 4AB3 9D 24 0F     @06      STA   UnitFlags,x              ;
2134 4AB6              *
2135 4AB6              * Preserve the low order six bits
2136 4AB6 A5 48                 LDA   CmdBlockl
2137 4AB8 29 3F                 AND   #$3F
2138 4ABA 8D 2A 0F              STA   sector
2139 4ABD              *
2140 4ABD              * Obtain a table driven "guess" for the track, sector.
2141 4ABD              *  Get index into table with CmdBlock div 64.
2142 4ABD A5 48                 LDA   cmdBlockl                ;
2143 4ABF 85 5A                 STA   temp                     ;dexxxxxx
2144 4AC1 A5 49                 LDA   cmdBlockh                ;0000 0abc  (max of 06)
2145 4AC3 26 5A                 ROL   temp
2146 4AC5 2A                    ROL   A                        ;0000 abcd
2147 4AC6 26 5A                 ROL   temp
2148 4AC8 2A                    ROL   A                        ;000abcde = Block DIV 64
2149 4AC9              *
2150 4AC9              * If this disk is 800K GCR offset to second half
2151 4AC9              *  of the track and sector tables.
2152 4AC9              * 
2153 4AC9 3C 24 0F              BIT   UnitFlags,x              ;is this single sided GCR vol?
2154 4ACC 10 03                 BPL   @10                      ;yes.
2155 4ACE              *
2156 4ACE 18                    CLC   
2157 4ACF 69 0D                 ADC   #13
2158 4AD1              *
2159 4AD1              @10      EQU   *
2160 4AD1 AA                    TAX                            ; set up table index
2161 4AD2 BF 44 4B FF           LDA   >sectab,x                ; sector number
2162 4AD6 48                    PHA                            ; save it
2163 4AD7 BF 1E 4B FF           LDA   >tracktab,x              ; track number
2164 4ADB A8                    TAY                            ; save it
2165 4ADC 68                    PLA                            ; restore sector number
2166 4ADD              *
2167 4ADD              * Y now has the track and A has the sector of the
2168 4ADD              *  requested CmdBlock with the low six bits clear.
2169 4ADD              *  Now we add the low six bits and correct an 
2170 4ADD              *  illegal mapping by subtracting off tracks
2171 4ADD              *  of sectors.
2172 4ADD AE 28 0F              LDX   drive                    ;TrackSect will need this
2173 4AE0 18                    CLC   
2174 4AE1 6D 2A 0F              ADC   sector
2175 4AE4 48           @20      PHA                            ;Preserve the sector number 
2176 4AE5 20 09 4B              JSR   TrackSect                ;A <- # sectors on current track 
2177 4AE8 85 5A                 STA   temp                     ;Keep A 
2178 4AEA 68                    PLA                            ;Pull back sector number 
2179 4AEB C5 5A                 CMP   temp                     ;Bigger than # on this track? 
2180 4AED 90 05                 BLT   @30                      ;No: block's been mapped; branch 
2181 4AEF C8                    INY                            ;Next track 
2182 4AF0 E5 5A                 SBC   temp                     ;Subtract # sectors that track 
2183 4AF2 80 F0                 BRA   @20                      ;Try again 
2184 4AF4              *
2185 4AF4              * Acc now has the sector, and X now has the track. 
2186 4AF4              *  In the case of a two sided disk, the track is
2187 4AF4              *  actually twice the cylinder, so correct for that.
2188 4AF4              *
2189 4AF4              ********************************************
2190 4AF4              *  Note that the carry is clear here.   ****
2191 4AF4 8C 29 0F     @30      STY   cyl
2192 4AF7 8D 2A 0F              STA   sector
2193 4AFA 3C 24 0F              BIT   UnitFlags,x
2194 4AFD 10 03                 BPL   @40
2195 4AFF              *
2196 4AFF              * The track (A) is really the cylinder*2 plus the side.
2197 4AFF              *  -> CCCCCCCS. Div by two puts cyl->A and side->carry.
2198 4AFF 4E 29 0F              LSR   cyl
2199 4B02 6E 2B 0F     @40      ROR   side                     ;shift in c=0 if 400K
2200 4B05 AD 2A 0F              LDA   sector                   ;recover a reg
2201 4B08 60                    RTS   
2202 4B09                       eject 
2203 4B09
2204 4B09                       TITLE 'Track Class & Number of Sectors'
2205 4B09              **************************************************
2206 4B09              *                                                *
2207 4B09              *  TrackSect        Determine the number of      *
2208 4B09              *                       sectors for a cylinder   *
2209 4B09              *                                                *
2210 4B09              *   Input:    Y <- the track                     *
2211 4B09              *             X <- the drive                     *
2212 4B09              *   Output:   A <- number of sectors this cyl    *
2213 4B09              *             class <- speed group (0-4)         *
2214 4B09              *   Prsrves:  X & Y (carry is set)               *
2215 4B09              *   Max time: 16 microsec  (2MHZ)                *
2216 4B09              *                                                *
2217 4B09              **************************************************
2218 4B09              TRACKSECT EQU   *
2219 4B09 98                    TYA   
2220 4B0A 3C 24 0F              BIT   UnitFlags,x              ;is volume 400K gcr format ?
2221 4B0D 10 01                 BPL   cylsect                  ;yes.
2222 4B0F 4A                    LSR   a                        ;map trk (0..159) to cyl (0..79)
2223 4B10              *
2224 4B10 4A           CYLSECT  LSR   a                        ;Alt entry for A <- cyl 
2225 4B11 4A                    LSR   a
2226 4B12 4A                    LSR   a
2227 4B13 4A                    LSR   a
2228 4B14 8D 2D 0F              STA   class
2229 4B17 A9 0C                 LDA   #12
2230 4B19 38                    SEC   
2231 4B1A ED 2D 0F              SBC   class                    ; 12-(0,1,2,3,4)=12..8
2232 4B1D 60           RETURN_3 RTS                            ;A has # of sectors per track
2233 4B1E              *
2234 4B1E              *
2235 4B1E              * This table contains the track number of blocks with
2236 4B1E              *  the low six bits clear.  The first part (13) are the
2237 4B1E              *  tracks for a single sided drive, the second (25) for
2238 4B1E              *  a double sided drive.
2239 4B1E              *
2240 4B1E                                                      ; SEG	code
2241 4B1E 00 05 0A 10  TRACKTAB DC B:0,5,10,16,21,27,33,40,46,53
2242 4B28 3C 44 4C              DC B:60,68,76
2243 4B2B 00 05 0A 10           DC B:0,5,10,16,21,26,32,37,43,49
2244 4B35 37 3D 43 49           DC B:55,61,67,73,80,86,92,99,106,113
2245 4B3F 78 80 88 90           DC B:120,128,136,144,152
2246 4B44              *
2247 4B44              * This is the sector table.  It has an organization
2248 4B44              *  just like that of the track table.
2249 4B44              *
2250 4B44 00 04 08 00  SECTAB   DC B:0,4,8,0,9,7,6,0,4,3,4,0,0
2251 4B51 00 04 08 00           DC B:0,4,8,0,4,8,0,9,7,5
2252 4B5B 03 01 02 06           DC B:3,1,2,6,0,4,8,5,6,7
2253 4B65 08 00 00 00           DC B:8,0,0,0,0
2254 4B6A                                                      ; SEG	fake_it
2255 4B6A              *
2256 4B6A              *
2257 4B6A                       TITLE 'Convert and Test block number'
2258 4B6A              *****************************************************************
2259 4B6A              *                                                               *
2260 4B6A              *  blockchk                Convert and test the coded block no. *
2261 4B6A              *                                                               *
2262 4B6A              *    This routine checks the block in the command table to see  *
2263 4B6A              *  if it is within the correct bounds for this disk.            *
2264 4B6A              *                                                               *
2265 4B6A              *   Regs:   A,X  destroyed                                      *
2266 4B6A              *           Y    preserved                                      *
2267 4B6A              *           C <-- 1 if block out of range; 0 otherwise          *
2268 4B6A              *   Time:   40 microseconds (no error)                          *
2269 4B6A              *                                                               *
2270 4B6A              *****************************************************************
2271 4B6A              BLOCKCHK EQU   *
2272 4B6A AE 28 0F              LDX   drive
2273 4B6D BD 3E 0F              LDA   volsts,x
2274 4B70 29 1F                 AND   #$1F                     ;get voltype
2275 4B72 AA                    TAX                            ;=2,4,6,8,10 etc
2276 4B73              *
2277 4B73              * Got a pointer to the block size for this disk, drive
2278 4B73 A5 4A                 LDA   CmdBlockl+2
2279 4B75 05 4B                 ORA   CmdBlockl+3
2280 4B77 D0 0E                 BNE   invalid_block
2281 4B79                       LONGA ON
2282 4B79 C2 20                 REP   #$20
2283 4B7B 48                    PHA                            ;preserve B for write 
2284 4B7C A5 48                 LDA   CmdBlockl
2285 4B7E DF 79 3C FF           CMP   >VolSizeTbl,x
2286 4B82 68                    PLA   
2287 4B83 E2 20                 SEP   #$20
2288 4B85                       LONGA OFF
2289 4B85 90 96                 BCC   return_3
2290 4B87              *
2291 4B87              * Lousy block number.  Set statbyte 
2292 4B87              INVALID_BLOCK EQU   *                   ;
2293 4B87 A9 2D                 LDA   #ibnerror                ;Flag illegal block number
2294 4B89 82 E3 F0              BRL   set_err                  ; mark an error
2295 4B8C              *
